rem "1ampCharger.BAS" 7/9/2007
rem Up to 1 amp for batteries from 1.4 to 12 volts
rem Usually used with gel cel lead-acid batteries
rem Needs mod and reloading for different voltages.
rem Has output for the Logging Terminal.
rem Current reduces gradually when charged.
rem John Saunders 3/17/2014 Added MAH measurement, new logic
#PICAXE 08M

symbol Phase	= bit0		'10 Hz
symbol Charging	= bit1
symbol HeadFlag	= Bit2		'1=Write the column headings
symbol Scratch	= b1
symbol Seconds	= b2
symbol Volts	= b3
symbol Hunds	= b4
symbol Tens		= b5
symbol Units	= b6
symbol Drive	= b7
symbol Carryover  = b8			'Amps not used for MAH last minute

symbol Analog	= w5			'Used for both outputs
symbol MAH		= w6			'Milliampere-Hours since plug was inserted


symbol PWMPeriod		= 60
symbol PWMMax		= 230
symbol PWMMin		= 215
symbol Chg_Volts 		= 143		'In tenths
symbol Flt_Volts		= 128
rem symbol PWMCharging	= 120	
rem symbol PWMFloating	= 115	
rem symbol Chg_Volts	=  46
rem symbol FltVolts	=  44 '4.4V

init:
let Phase = Pin3
LET Charging = 1
LET HeadFlag = 1
LET MAH      = 0
LET Carryover = 0
LET Seconds = 58
SETFREQ m4

looping:
IF Phase = Pin3 THEN looping 
LET Phase = Pin3
INC Scratch
IF Scratch < 10 THEN looping

rem 1 Hz processing
readadc10 4,Analog	'Analog value,goes negative, 2MA/count
if Analog > 10 then AnalogValid
PWMOUT 2,OFF
LET Charging = 1
LET HeadFlag = 1
LET MAH = 0
LET Carryover = 0
LET Seconds = 58
LET Scratch = 0
goto looping

rem Actual Charging, connector inserted and current flowing
AnalogValid:
IF HeadFlag = 1 THEN
	LET HeadFlag = 0
	SETFREQ m8
	HIGH C.0
	PAUSE 10
	LOW  C.0
	PAUSE 10
	SERTXD ("MAH,V,MA,PWM",13,10)
	SETFREQ m4
ENDIF

READADC10 1,Analog		'15V,15mV/count
LET Volts = Analog * 3 / 20	' in steps of 100 mv

READADC10 4,Analog	'Analog value,goes negative, 2MA/count
LET Analog = 1024 - Analog
LET Analog = 2*Analog		' current in ma

rem Second processing
LET Seconds = Seconds + 1
IF Seconds < 60 THEN 
	LET Scratch = 0
	GOTO looping
ELSE
	LET Seconds = 0
ENDIF

rem minute processing
SETFREQ m8
BINTOASCII Volts,Hunds,Tens,Units
HIGH C.0
PAUSE 10
LOW  C.0
PAUSE 10
SERTXD (#MAH,",",Hunds,Tens,".",Units,",",#Analog,",",#Drive,13,10)
SETFREQ m4
IF Volts < Flt_Volts THEN 
	LET Drive = PWMMax
	LET Charging = 1
ELSE
	IF Volts > Chg_Volts THEN
		LET Charging = 0
		LET Drive = PWMMin
	ENDIF
	IF  Charging = 0 THEN
		IF Volts <= Flt_Volts THEN
			LET Drive = PWMMax
		ELSE
			LET Drive = PWMMax - Volts + FLT_Volts
			IF Drive < PWMMin THEN
				LET Drive = PWMMin
			ENDIF
		ENDIF
	ENDIF
ENDIF
PWMOUT 2,PWMPeriod,Drive

rem MAH calculation
LET Analog = Analog + Carryover
LET Scratch = Analog / 60		'MAH increment
LET MAH = MAH + Scratch
LET Carryover = Analog // 60	'remainder

LET Scratch = 0
GOTO looping










