#rem
30VNiMhBattery,bas 5, 5-cell 2AH battery in series to be used with the charger with a matching XLR connector
The charger has a main charge output at 300 MA which can be reduced to 40 MA bu a HIGH on B.1,
When in Low mode, the white LED is lit
The battery voltage is displayed by red,Amber, Green and blue LEDs
John Saunders 10/13/2017
#endrem

#picaxe 14M2

rem Inputs
symbol TempPort  = C.0		'Junction of 2 thermisters; Embedded to common, reference to  to EnPort
symbol VoltPort  = C.4		'Battery voltage divided 0.108
symbol PowerPort = PinC.3	'High when the charger is connected and on
symbol PotPort   = B.2		'Potentiometer to adjust temperature trip value, range 90-125

rem Output ports
symbol LowPort   = B.1		'A high shuts down the main charging current
symbol EnPort    = C.2		'Excitation fo the thermisters and potentiometer
symbol RedLED    = C.1
symbol AmberLED  = B.3
symbol GreenLED  = B.4
symbol BlueLED   = B.5

rem constants
symbol TempHot    = 15	'Difference between temperature and reference, Above this the Battery is too hot
symbol TempCold	= 5
symbol LowThOn	= 177 '32V Above this swithch to low charge regardless of tehperature
symbol RedHi	= 162 'Above this the red LED os off
symbol AmberLo	= 160 'Lower limit of amber LED range
symbol AmberHi	= 164 'Upper limit of amber LED range
symbol GreenLo	= 163 'Lower limit of green LED range
symbol GreenHi	= 170 'Upper limit of green LED range
symbol BlueLo	= 168 'Lower limit of blue LED range

 
rem variables
symbol Temp         = bit0
symbol Power        = bit1	'0 is low charge, 1 = high charge
symbol Indx         = b1
symbol Iter		  = b2
symbol Reference    = b3	'Normally 110
symbol Temperature  = b4	'Cold is >= 105. nominal value 120, hot is 95
symbol Voltage      = b5
symbol Scratch      = b6
symbol TenThou      = b11
symbol Thou         = b12
symbol Hund         = b13
symbol BatteryVolts = w13

init:
SETFREQ m4
LET DIRSB = %00111011
LET DIRSC = %00000111
LOW EnPort
GOSUB ShowLEDs
LOW LowPort
GOSUB GetTemperature
IF Temperature >= TempHot THEN
	HIGH LowPort
ELSE
	LOW LowPort
ENDIF
LET Power = PowerPort
IF Power = 1 THEN main
end

main:
GOSUB GetTemperature
READADC VoltPort,Voltage
IF Temperature >= TempHot OR Voltage > LowThOn THEN
	HIGH LowPort
ENDIF
IF Temperature < TempCold AND Voltage < LowThOn THEN
	LOW LowPort
ENDIF
GOSUB ShowLEDs
PAUSE 100
GOTO main

GetTemperature:
HIGH EnPort
PAUSE 10
READADC TempPort,Temperature
READADC PotPort,Reference
LOW EnPort
IF Temperature <= Reference THEN
	LET Temperature = Reference -Temperature
ELSE
	LET Temperature = 0
ENDIF
RETURN

ShowLEDS:
READADC VoltPort,Voltage
IF Voltage < RedHi THEN
	HIGH RedLED
ELSE
	LOW RedLED
ENDIF
IF Voltage < AmberHi AND Voltage > AmberLo THEN
	HIGH AmberLED
ELSE
	LOW AmberLED
ENDIF
IF Voltage < GreenHi AND Voltage > GreenLo THEN
	HIGH GreenLED
ELSE
	LOW GreenLED
ENDIF
IF Voltage > BlueLo THEN
	HIGH BlueLED
ELSE
	LOW BlueLED
ENDIF
RETURN

DataOut:
READADC VoltPort,Voltage
LET BatteryVolts = 73 * Voltage
BINTOASCII BatteryVolts,TenThou,Thou,Hund,Scratch,Scratch
SETFREQ K500
SERTXD (0)
SETFREQ m8
PAUSE 12
SERTXD ("TenThou,",",Thou,Hund,",#Temperature,13,10)
SETFREQ m4	
RETURN