rem	600_LED_DISPLAY_2.BAS Used with 5 of the MPJA 18050-OP 120-LED matrices.
rem	The top row pins are connected together in 6 groups. The rest are in 2 groups

rem	Random version with speed controlled by the knob

#picaxe 08M

rem Pin Connections
symbol RegClock	= 0		'Output latch clock pin of the 74HC595 shift register
symbol ShiftClock	= 1		'Shift clock pin of the 74HC595 shift register
symbol Serinput	= 2		'Serial input pin of the 74HC595 shift register 
symbol PotPort	= 4		'The pin connected to the potentiometer wiper

rem variables			
symbol LowByte	= b0
symbol HighByte	= b1
symbol RandVal	= w0
symbol Iter		= b2		'General-purpose volatile
symbol Mask		= b3		'Used to determine the sign of each bit in shifting
symbol Code		= b4		'The 8-bit value sent to the display from the 74HC595
symbol PotValue	= b5
symbol DivVal	= b6
symbol BitPos	= b7

rem constants
symbol Speed	= 50		'Default main loop period

init:
LOW RegClock	'The output latches of a 74HC595 are positive-edge triggered			'
LOW ShiftClock	'The shift clock of a 74HC595 is positive-edge triggered

main:
FOR Iter = 0 to 3			'
	Random Randval
	Lookup Iter,(1,8,32,128),DivVal
	LET Code = RandVal/DivVal
	GOSUB Shift595	
next Iter
goto main


Shift595:
READADC PotPort,PotValue			'Knob position
IF PotValue < 10 THEN				'Turn off all LEDs
	LET Code = 0
	LET PotValue = Speed
ELSE							'Scroll at a rate determined by the knob
	LET PotValue = 257 - PotValue
ENDIF
FOR Bitpos = 0 TO 7
	LOOKUP Bitpos,(128,64,32,16,8,4,2,1),Mask
	LET Mask = Code & Mask 
 	LOW Serinput
	IF Mask = 0 then Databitislow
	HIGH Serinput
Databitislow:
	PULSOUT ShiftClock,10
NEXT Bitpos
PULSOUT RegClock,10
PAUSE PotValue
return




