rem	600_LED_DISPLAY.BAS used with 5 of the MPJA 18050-OP 120-LED matrices.
rem	The top row pins are connected together in 6 groups. The rest are in 2 groups

rem	Version with scrolling to the right at a speed controlled by the knob

#picaxe 08M

rem Port Connections
symbol RegClock	= 0		'Output register clock port of the 74HC595 shift register
symbol ShiftClock	= 1		'Shift clock port of the 74HC595 shift register
symbol Serinput	= 2		'Serial input port of the 74HC595 shift register 
symbol PotPort	= 4		'The port connected to the potentiometer wiper

rem variables			
symbol LeftRows	= bit0	'1 is rows 1 - 11 on left half of each bank lit
symbol RightRows	= bit1	'1 is rows 1 - 11 on right half of each bank lit
symbol Iter		= b1		'General-purpose volatile
symbol ColPos	= b2		'Values 1 - 6 are the columns, left to right in
rem					'each half of each bank. 7 is all selected
symbol Bitpos	= b3		'0 - 7 is the bit position in Code for shifting
symbol Mask		= b4		'Used to determine the sign of each bit in shifting
symbol TopRow	= b5		'Values 1 - 5 are the colored LEDs on the top row
rem					'from left to right, 7 is all on
symbol Code		= b6		'The 8-bit value sent to the display
symbol PotValue	= b7		'Analog value from the potentiometer

rem constants
symbol Speed	= 50		'Default main loop period

init:
LOW RegClock	'The output latches of a 74HC595 are positive-edge triggered			'
LOW ShiftClock	'The shift clock of a 74HC595 is positive-edge triggered

main:
FOR TopRow = 1 to 6		'Scroll the top row LED groups from left to right
	for ColPos = 1 to 5
		LET LeftRows = 0
		LET RightRows = 0
		GOSUB Shift595
		PAUSE PotValue
	next ColPos
next TopRow
FOR Iter = 0 to 4			'Repeat 5 times
	LET TopRow = 0
	for ColPos = 1 to 5	'Scroll the 5 left bars through the 5 left columns
		LET LeftRows = 1
		LET RightRows = 0
		GOSUB Shift595
		PAUSE PotValue
	next ColPos
	for ColPos = 1 to 5	'Scroll the 5 right bars through the 5 right columns
		LET LeftRows = 0
		LET RightRows = 1
		GOSUB Shift595
		PAUSE PotValue
	next ColPos
next Iter
goto main





Shift595:
READADC PotPort,PotValue			'Knob position
IF PotValue < 10 THEN				'Turn off all LEDs
	LET Code = 0
	LET PotValue = Speed
ELSEIF PotValue > 250 THEN			'Turn on all LEDs
	LET Code = 255
	LET PotValue = Speed
ELSE							'Scroll at a rate determined by the knlb
	LET PotValue = 260 - PotValue
	LET Code = 2 * RightRows + LeftRows
	LET Code = 4 * TopRow + Code 
	LET Code = 32 * ColPos + Code 
ENDIF
FOR Bitpos = 0 TO 7
	LOOKUP Bitpos,(128,64,32,16,8,4,2,1),Mask
	LET Mask = Code & Mask 
 	LOW Serinput
	IF Mask = 0 then Databitislow
	HIGH Serinput
Databitislow:
	PULSOUT ShiftClock,10
NEXT Bitpos
PULSOUT RegClock,10
return



