rem	600_LED_DISPLAY_2.BAS Used with 5 of the MPJA 18050-OP 120-LED matrices.
rem	The top row pins are connected together in 6 groups. The rest are in 2 groups

rem	Version with two-way scrolling and flashing, speed controlled by the knob

#picaxe 08M

rem Pin Connections
symbol RegClock	= 0		'Output latch clock pin of the 74HC595 shift register
symbol ShiftClock	= 1		'Shift clock pin of the 74HC595 shift register
symbol Serinput	= 2		'Serial input pin of the 74HC595 shift register 
symbol PotPort	= 4		'The pin connected to the potentiometer wiper

rem variables			
symbol LeftRows	= bit0	'1 is rows 1 - 11 on left half of each bank lit
symbol RightRows	= bit1	'1 is rows 1 - 11 on right half of each bank lit
symbol ScrollDir	= bit3	'1 is scroll bars towards the right, 0 to the left
symbol ScrollSet	= bit4	'1 selects the right half of rows 1-11 for scrolling
symbol Iter		= b1		'General-purpose volatile
symbol ColPos	= b2		'Values 1 - 6 are the columns, left to right in
rem					'each half of each bank. 7 is all selected
symbol Bitpos	= b3		'0 - 7 is the bit position in Code for shifting
symbol Mask		= b4		'Used to determine the sign of each bit in shifting
symbol TopRow	= b5		'Values 1 - 5 selects one of the groups of colored LEDs
rem					'on the top row, from left to right, 7 is all on
symbol Code		= b6		'The 8-bit value sent to the display from the 74HC595
symbol PotValue	= b7		'Analog value from the potentiometer

rem constants
symbol Speed	= 50		'Default main loop period

init:
LOW RegClock	'The output latches of a 74HC595 are positive-edge triggered			'
LOW ShiftClock	'The shift clock of a 74HC595 is positive-edge triggered

main:
LET LeftRows = 0
LET RightRows = 0
FOR TopRow = 1 to 6		'Scroll the top row LED groups from left to right
	for ColPos = 1 to 5
		GOSUB Shift595
	next ColPos
next TopRow
rem Now scroll the bars 5 times from left to right
LET TopRow = 0
FOR Iter = 0 to 4			'Repeat 5 times
	LET ScrollDir = 1
	LET ScrollSet = 0
	GOSUB scrollRows
	LET ScrollSet = 1
	GOSUB scrollRows
next Iter
rem Now scroll the bars 5 times from right to left
FOR Iter = 0 to 4			'Repeat 5 times
	LET ScrollDir = 0
	LET ScrollSet = 1
	GOSUB scrollRows
	LET ScrollSet = 0
	GOSUB scrollRows
next Iter
rem Now bling all LEDs 5 times
FOR Iter = 0 to 4			'Repeat 5 times
	LET LeftRows = 0
	LET RightRows = 0
	LET TopRow = 0
	LET ColPos = 0
	GOSUB Shift595
	LET LeftRows = 1
	LET RightRows = 1
	LET TopRow = 7
	LET ColPos = 7
	GOSUB Shift595
next Iter
goto main



scrollRows:				'Scroll the bars through the columns
IF ScrollSet = 0 THEN		'Scroll the left rows
	LET LeftRows = 1
	LET RightRows = 0
ELSE					'Scroll the right rows
	LET LeftRows = 0
	LET RightRows = 1
ENDIF
IF ScrollDir = 0 THEN		'Scroll right to left
	FOR ColPos = 5 TO 1 STEP -1	
		GOSUB Shift595
	NEXT ColPos
ELSE					'Scroll left to right
	FOR ColPos = 1 TO 5 
		GOSUB Shift595
	NEXT ColPos
ENDIF
return

Shift595:
READADC PotPort,PotValue			'Knob position
IF PotValue < 10 THEN				'Turn off all LEDs
	LET Code = 0
	LET PotValue = Speed
ELSE							'Scroll at a rate determined by the knlb
	LET PotValue = 257 - PotValue
	LET Code = 2 * RightRows + LeftRows
	LET Code = 4 * TopRow + Code 
	LET Code = 32 * ColPos + Code 
ENDIF
FOR Bitpos = 0 TO 7
	LOOKUP Bitpos,(128,64,32,16,8,4,2,1),Mask
	LET Mask = Code & Mask 
 	LOW Serinput
	IF Mask = 0 then Databitislow
	HIGH Serinput
Databitislow:
	PULSOUT ShiftClock,10
NEXT Bitpos
PULSOUT RegClock,10
PAUSE PotValue
return




