#rem
AlphaLEDClockCont.bas This is the clock with the green line of LEDs in a wood cabinet
It is used with a PC keyboard
Changes to Baseline3: New limits on Rate
John Saunders 11/7/2014

#picaxe 14M2

#rem DS1307 address map:
0-7  maintained by the clock - see data sheet
$08=Page to display (0-8),$09=Blinking Character Poition (0-23),$0A=Timer index (0-5),$0B=Command
Timers: each timer has 4 bytes: Hour, Minute, Rate, Type, which are grouped, starting at $0C
The type codes ere; "P" Change page (0,4-7 only), "S'Sound, 3-7 MSN of RF code in hex
The parameters are hex LSN
The variable message uses $28 - $3F
#endrem

rem variables 
symbol 	Grant      = bit0		'Handshaking for RTC access
symbol      CapsLock   = bit1		'Output of a circuit which brackets the IR burst
symbol      ScanCode1  = b1		'Checks that it is a real remote signal
symbol 	ScanCode2  = b2		'requires two successive receptions in the burst
rem Interchange variables:
symbol	Command    = b3		'Immediate RF or Receptace keystroke
symbol	Page	     = b4		'line of characters index
symbol	TimerIndex = b5		'Selects 1 of 6 timers for setting values
symbol	BlinkIndex = b6		'Index of no of items to adjust on a page
symbol	BlinkPos   = b7		'Position on line of nibble being set
rem Input analysis variables:
symbol	UpDown     = bit2		'Related button presses discriminator
symbol	MSN	     = bit3		'Editing by nibble
symbol	Updated    = bit4		'Something changed in RTC addresses 8-11
symbol	PwrOn      = bit5		'Rear receptacle is on
symbol      NvAddr     = b8		'An address in EEPROM
symbol	RTCAddr    = b9		'An address in the DS1307 Real-Time Clock
symbol	HighLimit  = b10		'maximum legal value of a nibble
symbol      LowLimit   = b11		'minimum legal value of a nibble
rem general variables
symbol	Index      = b12		'For loops
symbol	CharData   = b13		'An ASCII value
symbol      DECData    = b14		'A binary value
symbol      Units      = b15		'Least significant nibble of a BCD value
symbol	BCDData    = b16		'A BCD value
symbol	Scratch    = b17
symbol	Tens       = b18

rem outputs
symbol	sda    = B.4	'RTC sda i2c line
symbol	scl    = B.3	'RTC sdl i2c line
symbol	Rqst   = C.0	'Ask Display Processor Display Access
symbol      Relay  = B.1      'High sets the relay to control processor RTC access
symbol	PwrOut = B.2
rem inputs
symbol	Grant_Port   = pinB.5	'Display Processor permits RTC access

rem data
rem Time and date adjust for Page 6, Clock set
DATA 0, ( 4, 7,13,16,19,22)	'Position of MSB data to be edited on the screen
DATA 8, ( 2, 1, 3, 5, 4, 6)	'Corresponding RTC address
DATA 16,(23,59, 7,12,31,99)	'High Limit
DATA 24,( 0, 0, 1, 1, 1,13)	'Low Limit

rem Timer adjust for page 7, timer set
DATA 32,( 8,11,14,16,20,21)	'Position of MSB data to be edited on the screen
DATA 40,(12,13,14,14,15,15) 	'RTC Address, for TimerIndex = 0
DATA 48,(23,59, 5,12, 7,15)	'High Limit
DATA 56,( 0, 0, 0, 0, 0, 0)	'Low Limit

symbol ESC      = $76
symbol F1       = $05
symbol F2       = $06
symbol F3       = $04
symbol F4       = $0C
symbol F5       = $03
symbol F6       = $0B
symbol F7       = $83
symbol F8       = $0A
symbol F9       = $01
symbol RtArrow  = $74
symbol LftArrow = $6B
symbol UpArrow  = $75
symbol DnArrow  = $72
symbol CLCode   = $58

#rem	Page descriptions
0	Display Current time,day(string) month(string) date, temperature
1	Display fixed message 1
2	Display fixed message 2
3	Display fixed message 3
4	Display fixed message 4
5	Display variable message
6	Set hour minute day month date year
7	Display selected timer number, Set timer Hour Minute Rate Type
8	Edit variable message
#endrem

rem Timer change keys
symbol One      = $16	'Edit timer 1
symbol Two      = $1E	'Edit timer 2
symbol Three    = $26	'Edit timer 3
symbol Four     = $25	'Edit timer 4
symbol Five     = $2E	'Edit timer 5
symbol Six      = $36	'Edit timer 6
symbol Seven    = $3D	'Edit timer 7

#rem Direct RF Command keys and corresponding codes
Rear Receptacle		ON	OFF
Key				Q	W
Scan Code			$15	$1D
Action Entry		+	-

Hanging Lamp		ON	OFF
Key				E	R
Scan Code			$24	$2D
Action Entry		7	6		

Floor Lamp			ON	OFF
Key				T	Y
Scan Code			$26	$35
Action Entry		b	f		

Pinapple Lamps		ON	OFF
Key				U	I
Scan Code			$3C	$43
Action Entry		K	8

Shelf Edge Lamps		ON	OFF
Key				O	P
Scan Code			$44	4D	
Action Entry		E	F

Display Case Lamps	OFF	Top/Models	Circle	Bullseye
Key				A	S		D		F
Scan Code			$16	$1B		$23		$2B	
Action Entry		W	Y		P		M

Tri-Color Mobile		OFF	Red	Green		Blue
Key				H	J	K		L
Scan Code			$33	$3B	$42		$4B	
Action Entry		W	R	G		B

4 Socket/24 V		OFF	W	R	G	B	24V
Key				Z	X	C	V	B	N
Scan Code			$1A	$22	$21	$42	432	$31	
Action Entry		0	1	2	3	4	5

Flower Receiver		ON	OFF
				G	M
				$34	$3A
				a	c
#endrem

DATA 92, ($15,$1D,$24,$2D,$2C,$35,$3C,$43,$44,$4D,$1C,$1B,$23,$2B,$33,$3B,$42,$4B,$1A,$22,$21,$2A,$32,$31,$34,$3A,$3D,$29,$49,$41,$4A,0)
DATA 125,("+   -   7   6   b   f   K   8   E   F   W   Y   P   N   W   R   G   B   0   1   2   3   4   5   a   c   e   l   m   n   o")
DATA 160,("QWERTYUIOPASDFHJKLZXCVBNGM& .,?")
symbol RFScanAddr = 92
symbol RFCodeAddr = 125
symbol ASCIICodeaddr = 160

startup:
SETFREQ m4
LET Page = 0
LET BlinkIndex = 0
LET TimerIndex = 0
LET CharData = 0
LET Command = 0
LET Updated = 1
LET CapsLock = 0
LET PwrOn = 0
I2CSLAVE %11010000,i2cslow,i2cbyte
PAUSE 25 
LET RTCAddr = $07
LET BCDData = $10		'Set 1Hz square wave on
GOSUB WriteRTC

main:
LET ScanCode1 = 255
rem Wait For Input
KBIN [1000,main],ScanCode1
IF Scancode1 = 255 THEN main
IF ScanCode1 = CLCode THEN
	LET CapsLock = CapsLock ^ 1
	LET Scratch = 4 * CapsLock + $80
	KBLED Scratch
ENDIF

rem Analyse
LET RTCAddr = 0					'Marker
LET Updated = 0

rem is this a direct command?
IF Page < 6 THEN
	LET Index = 255
	DO
		INC Index
		LET NvAddr = RFScanAddr + Index
		READ NvAddr,BCDData
	LOOP WHILE BCDDAta > 0 AND BCDData <> ScanCode1 
	IF BCDData > 0 THEN
		LET NvAddr = RFCodeAddr + Index
		READ NvAddr,Command
		IF Command = "+" THEN
			LET PwrOn = 1
		ENDIF
		IF Command = "-" THEN
			LET PwrOn = 0
		ENDIF
		LET Updated = 1
	ELSE
		LET Command = 0
	ENDIF
ELSE
	LET Command = 0
ENDIF

rem Did the page change?
rem Get Current Page if pressed
LET Index = 255
LOOKDOWN ScanCode1,(ESC,F1,F2,F3,F4,F5,F6,F7,F8),Index
IF Index < 9 THEN
	LET Page = Index
	LET Updated = 1
	IF Page > 5 THEN
		LET Scratch = Page - 6
		LOOKUP Scratch,(4,9,0),BlinkPos
	ENDIF
ENDIF

rem Did Timer number Change?
IF Page = 7 THEN
	LET Index = 255
	LOOKDOWN ScanCode1,(One,Two,Three,Four,Five,Six,Seven),Index
	IF Index < 7 THEN
		LET TimerIndex = Index
		LET Updated = 1
	ENDIF
ENDIF

IF Page > 5 THEN
rem Did Blink Position Change?
	LET Index = 255
	LOOKDOWN ScanCode1,(LftArrow,RtArrow),Index
	IF Index < 2 THEN
		LET Updown = Index
		GOSUB AdjustBlinkPos
		LET Updated = 1
	ENDIF
ENDIF

rem Did a value change?
IF Page = 6 OR Page = 7 THEN
	LET Index = 255
	LOOKDOWN ScanCode1,(DnArrow, UpArrow),Index
	IF Index < 2 THEN
		LET Updown = Index
		GOSUB GetValue				'Sets the RTCAddr, puts value into BCDData
		GOSUB GetLimits				'Get the high and low limits for this value
		IF Page = 7 AND BlinkIndex > 1  THEN
			GOSUB AdjustRateType
		ELSE						'Page 6 or 7
			GOSUB AdjustBCD
		ENDIF
	ENDIF					'Returns changed BCDData, no change to RTCAddr
ENDIF	

rem Editing the variable message
IF Page = 8 THEN
	GOSUB EditVariable
ENDIF	


LET Scratch = 4 * CapsLock + $82 + PwrOn
KBLED Scratch
GOSUB WriteRTC
LET Scratch = 4 * CapsLock + $80 + PwrOn
KBLED Scratch
rem Wait For release
KBIN [1000,main],ScanCode2
PAUSE 500				'Wait for the extra pulses the Philips keyboard sends
GOTO main

rem subroutines

WriteRTC:
HIGH Rqst
DO
	LET Grant = Grant_Port
LOOP WHILE Grant = 0
HIGH Relay
PAUSE 15 
IF Updated = 1 THEN
	WRITEI2C $08,(Page,BlinkPos,TimerIndex,Command)
	LET Updated = 0
ELSE
	IF RTCAddr < 64 THEN	
		WRITEI2C RTCAddr,(BCDdata)
		IF RTCAddr = 1 THEN			'Adjust minutes
			WRITEI2C 0,($30)			'Make sure clock starts
		ENDIF
	ENDIF
ENDIF
LOW Relay
PAUSE 15
LOW Rqst
RETURN

AdjustBlinkPos:
LET Scratch = Page - 6			'Get high number of BlinkIndex
LOOKUP Scratch,(5,5,23),HighLimit
IF UpDown = 1 THEN
	IF BlinkIndex >= HighLimit THEN
		LET BlinkIndex = 0
	ELSE
		INC BlinkIndex
	ENDIF
ELSE
	IF BlinkIndex = 0 THEN
		LET BlinkIndex = HighLimit
	ELSE
		DEC BlinkIndex
	ENDIF
ENDIF
IF Page = 8 THEN
	LET BlinkPos = BlinkIndex
	RETURN
ENDIF
IF Page = 7 THEN
	LET NvAddr = 32 + BlinkIndex	'Get Blink Position location
ELSE 		'Page 6 
	LET NvAddr = BlinkIndex	'Get Blink Position location
ENDIF
READ NvAddr,BlinkPos 'Get Blink Position
RETURN

GetValue:	'Get the value to be changed from RTCAddr into BCDData
rem Get the RTC Address of the value
IF Page = 7 THEN
	LET NvAddr = 40 + BlinkIndex	'Get RTC Address location
	READ NvAddr,RTCAddr		'Get RTC Address for timer 0
	LET RTCAddr = 4 * TimerIndex + RTCAddr	'Adjust for other timer
ELSE 		'Page 6
	LET NvAddr = 8 + BlinkIndex	'Get RTC Address location
	READ NvAddr,RTCAddr		'Get RTC Address of the iten
ENDIF
rem read the RTC:
HIGH Rqst
DO
	LET Grant = Grant_Port
LOOP WHILE Grant = 0
HIGH Relay
PAUSE 5 	
READI2C RTCAddr,(BCDData)
LOW Relay
PAUSE 5
LOW Rqst
RETURN

GetLimits:				'Get the high and low limits for this value
IF Page = 6 THEN
	LET NvAddr = 16 + BlinkIndex
ELSE
	LET NvAddr = 48 + BlinkIndex
ENDIF
READ NVAddr,HighLimit
LET NvAddr = NvAddr + 8
READ NVAddr,LowLimit
RETURN

AdjustBCD:				'Alters value in BCDData, according to UpDown,HighLimit & LowLimit
LET Tens = BCDData & $F0
LET Tens = Tens / 16
LET Units = BCDData & $0F
IF Units > 9 THEN
	LET Units = 9
ENDIF
IF Tens > 9 THEN
	LET Tens = 9
ENDIF
LET DecData = 10 * Tens + Units
IF UpDown = 1 THEN
	IF Decdata >= HighLimit THEN
		LET DecData = LowLimit
	ELSE
		INC DecData
	ENDIF
ELSE
	IF DecData > LowLimit THEN
		DEC DecData
	ELSE
		LET DecData = HighLimit
	ENDIF
ENDIF
LET Units = DecData // 10
LET Tens = Decdata / 10
LET BCDData = 16 * Tens + Units
RETURN

AdjustRateType:
LET Tens = BCDData /16
LET Units = BCDData & $0F
IF BlinkIndex = 2 OR BlinkIndex = 4 THEN
	LET Chardata = Tens
ELSE
	LET CharData = Units
ENDIF
IF UpDown = 1 THEN
	IF CharData >= HighLimit THEN
		LET CharData  = 0
	ELSE
		INC CharData 
	ENDIF
ELSE
	IF CharData  = 0 THEN
		LET CharData  = HighLimit
	ELSE
		DEC CharData 
	ENDIF
ENDIF
IF BlinkIndex = 2 OR BlinkIndex = 4 THEN
	LET BCDdata = 16 * Chardata + Units
ELSE
	LET BCDData = 16 * Tens + CharData
ENDIF
RETURN

EditVariable:
LET Index = 255
DO							'Find the scancode for the input
	INC Index
	LET NVAddr = RFScanAddr + Index
	READ NVAddr,CharData 
LOOP WHILE CharData > 0 AND ScanCode1 <> CharData
IF Chardata > 0 THEN				'Get corresponding ASCII character
	LET NvAddr = ASCIICodeAddr + Index
	READ NvAddr,BCDData 
	IF CapsLock = 0 AND Index < 26 THEN	'Lower Case
		LET BCDData = BCDData + $20
	ENDIF
	LET RTCAddr = $28 + BlinkPos
ENDIF
RETURN
