#rem "14M2_Altimeter_Barmeter_Voltmeter.bas"
John Saunders 5/22/2015 added barometer
#endrem
#PICAXE 14M2


symbol AltitudeRange	= bit2
symbol Iter			= b1
symbol Digit		= b2
symbol SettingCounter	= b3
symbol BitPos		= b4
symbol Mask			= b5
symbol ReadingCounter	= b6
symbol DisplayMode	= b7		'0=Altimeter,1=Setting,2=Barometer,3=Voltmeter
symbol BaroBase		= w8
symbol Reading		= w9
symbol ZeroAlt		= w10
symbol AnalogValue	= w11

rem Input-Output
symbol Clock		= B.1		'Drives Display Controller MC14489
symbol Enable		= B.2
symbol Outdata		= B.3
symbol Upbutton		= PINC.1
symbol Downbutton		= PINC.2


rem Constants
symbol ThreeDigitCmd	= %0111	'For blanking 2 leading zeroes
symbol FourDigitCmd	= %0011	'For blanking 1 leading zero
symbol FiveDigitCmd	= %0001
symbol Cmd4MSB		= %0100
symbol VoltOffset		= 509		'Adjusts voltage range to 5 - 15V
symbol UpperRangePoint	= 508		'5700 ft altitude, provides hysterisis
symbol UpperRangeBase	= 13500	'Best fit by analysis for > 5500'
symbol LowerRangePoint	= 538		'5300 ft altitude, provides hysterisis
symbol LowerRangeBase	= 12250	'Best fit by analysis for < 5500'
symbol Altimeter 		= 0
symbol Setting 		= 1
symbol Barometer		= 2
symbol Voltmeter		= 3
symbol BaroMult		= 32
symbol BaroDivisor	= 25

DATA 0,(8,4,2,1)				'Mask of bits for DispHex

init:
High Enable					'Low is active for MC14489
LET ZeroAlt = LowerRangeBase
IF Upbutton = 1 THEN
	LET DisplayMode = Barometer
ELSE
	LET DisplayMode = Altimeter
ENDIF

main:	
pause 100

IF Upbutton  = 1 AND Downbutton = 1 AND DisplayMode = Altimeter THEN	'To set for barometer correction
	LET DisplayMode = Setting
	DEC SettingCounter
ENDIF

IF DisplayMode <> Setting THEN
	IF Upbutton  = 1 THEN
		LET DisplayMode = Altimeter
	ENDIF
	IF Downbutton  = 1 THEN
		LET DisplayMode = Voltmeter
	ENDIF
ENDIF

IF DisplayMode	= Voltmeter THEN	
	READADC10 C.4,AnalogValue
ELSEIF DisplayMode = Altimeter THEN
	READADC10 C.0,AnalogValue
	IF AltitudeRange = 0 AND AnalogValue < UpperRangePoint THEN
		LET AltitudeRange = 1
		LET ZeroAlt = UpperRangeBase
	ELSEIF AltitudeRange = 1 AND AnalogValue > LowerRangePoint THEN
		LET AltitudeRange = 0
		LET ZeroAlt = LowerRangeBase
	ENDIF
ELSEIF DisplayMode = Barometer THEN
	READADC10 C.0,AnalogValue
ENDIF
INC ReadingCounter
LET Reading = Reading + AnalogValue
IF DisplayMode = Altimeter THEN
	LET Digit = 3 * AltitudeRange + 13
ELSE
	LET Digit = BaroMult
ENDIF
IF ReadingCounter >= Digit THEN
RepeatSetting:
	IF DisplayMode = Voltmeter THEN
		LET AnalogValue = Reading / Digit + VoltOffset
	ELSEIF DisplayMode = Altimeter THEN
		IF Reading > ZeroAlt THEN
			LET AnalogValue = Reading - ZeroAlt + 50000 'To display a "L" for negative altitudes
		ELSE
			LET AnalogValue = ZeroAlt - Reading
		ENDIF
	ELSEIF DisplayMode = Barometer THEN
		LET AnalogValue = Reading/BaroDivisor + BaroBase	'In 1/100" Hg
	ENDIF

'Send the number to the MC14489 display controller
	Low Enable
	LET Digit = Cmd4MSB
	GOSUB SendHex
	LET Digit = ThreeDigitCmd
	IF AnalogValue < 1000 OR AnalogValue > 20000 THEN SendCmd
	LET Digit = FourDigitCmd
	IF AnalogValue < 10000 THEN SendCmd
	LET Digit = FiveDigitCmd
SendCmd:
	GOSUB SendHex			'This blanks leading zeroes
	PULSOUT Enable,10
	IF DisplayMode = Setting THEN
		LET Digit = 7 	'Displays an "C" in setting Mode by energising segments a,d,e,f
	ELSE
		LET Digit = 0 	 
	ENDIF
	GOSUB SendHex
	FOR Iter = 0 to 4
		LET Digit = AnalogValue // 10
		LET AnalogValue = AnalogValue / 10
		GOSUB SendHex
	NEXT
	High Enable
'End sending number
	IF DisplayMode = Setting THEN
		IF Upbutton  = 1 THEN
			INC ZeroAlt
		ENDIF
		IF Downbutton  = 1 THEN
			DEC ZeroAlt
		ENDIF
		IF SettingCounter > 0 THEN
			DEC SettingCounter
			GOTO RepeatSetting
		ELSE 
			LET DisplayMode = Altimeter	'Timer to terminate setting mode
		ENDIF
	ENDIF
	LET ReadingCounter = 0
	LET Reading = 0
ENDIF
goto main


SendHex:				'Input is in digit
FOR BitPos = 0 TO 3		'Faster than the shiftout workaround in the manual
	READ BitPos,Mask
	LET Mask = Digit & Mask 
 	LOW Outdata
	IF Mask = 0 then Charbitislow
	HIGH Outdata
Charbitislow:
 	PULSOUT Clock,1
NEXT
RETURN
	



























