#rem Blue_LED.bas    
Subsystem for GE 1941 radio bluetooth speaker to operate a blue LED when paired
The diaj jight turns off when paired
John Saunders 10/24/2016
#endrem
#picaxe 08M2

'Input port
symbol Photocell_Port = C.4	'Light makes higher voltage, 15 kilohm pulldown

'Output ports
symbol Dial_Port    = C.2	'High provides 40 MA to two dial lights
symbol LED_Port      = C.1	'High provides 10 MA to the blue LED

'Constants
symbol On_Threshold   = 150	'> Enables pullin
symbol Off_Threshold  = 75	'< Drops out

'Variables
symbol Photocell      = b2	'Analog photocell input

init:
SETFREQ m4
LOW LED_Port
LOW Dial_Port 


main:
READADC Photocell_Port,Photocell
IF Photocell > On_Threshold THEN
	LOW Dial_Port
	HIGH LED_Port
ENDIF
IF Photocell < Off_Threshold THEN
	LOW LED_Port
	HIGH Dial_Port 
ENDIF
PAUSE 100
GOTO main