rem "AutoVTVM.BAS" 8/17/2009
rem An ancient Volt-Ohmmeter was refurbished using a PICAXE instead of RTL logic.
rem It has 8 voltage and 16 resistance 5-15 ranges, selected by relays.
rem There is a single control, a voltage-ohm switch.
rem It uses a rectifier in the meter amplifier feedback to measure voltages
rem of either polarity or AC without switching. AC gain is modified automatically
rem to correct for average-RMS of a sine-wave.
rem Indicator lamps show the range in use and the mode: Positive, Negative or AC
rem voltage, or Kilo or Megohm resistance.
rem There are three inputs to the PICAXE:
rem Pin 0 is high in voltage mode, connected to the ohms relay coil
rem Pin 1 is analog meter current from an opto-isolator and is low-pass filtered
rem Pin 2 is the low-pass filtered output of the meter amplifier. 
rem Due to the bridge rectifier and the opto-isolator diode there is
rem at least a 2.5 volt drop in the feedback path when in range.
rem On AC the mode voltage averages out to zero.
rem A bias results in a 0.5 to 4V span, neg high as the amplifier inverts.
rem There are 8 outputs.
rem Pins 0-2 are the range. They go to ancient diode NAND decoders to illuminate
rem a single range lamp and the coils of three reed relays which control the dividers.
rem Pin 3 is the gate of a 74259. This chip has a demux and 8 D registers, which can be
rem individually set. In this circuit, they can only be all cleared at once.
rem Pins 4-6 select the 74259 register to set. 0-4 are the mode lamps, 4 is the megohm
rem lamp and also the megohm relay. Output 6 is the meter enable. 5 & 7 not used
rem Pin 7 is the 74259 clear.
    
#PICAXE 18X
#Com 1



rem Bit variables - uses bytes 0 and 1
symbol NewRange		= bit1	'Set temporally when range changes
symbol Ohms			= bit2	'Set in ohms mode

rem word variables - uses bytes 2 - 5
symbol Current		= w1		'The current through the meter via on opto-isolator
symbol ModeSense		= w2		'The voltage at the output of the meter amplifier

rem byte variables - uses bytes 8 - 11
symbol Range		= b8		'0-7 corresponds to ranges 0.015 through 50
symbol Allouts		= b9		'This sets all of the output pins at once
symbol Mode			= b10		'0=Pos.1=AC,2=Neg,3=Kohm,4=Megohm,>4=all off		

rem constants
symbol Pos			= 300		'ModeSense less than this indicated a positive voltage
symbol Neg			= 600		'ModeSense greater than this indicated a negative voltage
symbol GoDown		= 30		'Current less than this causes a lower range
symbol GoUp			= 400		'Current greater than this causes a higher range



Init:
SETFREQ m4
LOW 3				'Ensures the idle state of the 74259 gate
LET Range = 4		'Start in middle
IF pin0 = 0 THEN		'Test for ohms-volts selection
	LET Mode = 3
	LET Ohms = 1
ELSE
	LET Mode = 0
	LET Ohms = 0
ENDIF
LET NewRange = 1		'Ensures entering the range into the pins
PAUSE 200			'Settle the circuits
READADC10 1, Current	'Initial meter current reading

Main:
rem Test for in-range and increment/decrement if needed
IF Current > GoUp THEN
	IF Range < 7 THEN
		LET Range = Range + 1
	ELSE			'Go to megohms if high on 50 range
		IF Ohms = 1 THEN 
			LET Mode = 4
		ENDIF
	ENDIF
	LET NewRange = 1
ELSEIF Current < GoDown THEN
	IF Range > 0 THEN
		LET Range = Range - 1
	ELSE			'Go to Kohms if low on 0.015 range
		IF Ohms = 1 THEN 
			LET Mode = 3
		ENDIF
	ENDIF
	LET NewRange = 1
ENDIF
rem since the PICAXE must set all 8 pins at once, must also set the mode lamp
IF NewRange = 1 THEN	'Enter range into pins to illuminate a lamp and energise relays
	LOW 7			'Clear all 74259 outputs, lamps and meter enable
	LET Allouts = Range & 7	
	LET Allouts = 16 * Mode + allouts + 128 'lift 74259 clear and set one mode lamp
	LET pins = Allouts
	PULSOUT 3,1		'Pulse the 74259 gate
	LET NewRange = 0
ENDIF
PAUSE 200			'Wait for the current and range low-pass filters to settle
rem Only read the mode and enable the meter if the current is withing the limits
READADC10 1, Current
IF Current > GoDown AND Current < GoUP THEN
	READADC10 2, ModeSense
	LOW 7			'Clear all 74259 outputs
	IF Ohms = 0 THEN	'Voltage mode only	
		IF ModeSense > Neg THEN
			LET Mode = 2
		ELSEIF ModeSense < Pos THEN
			LET Mode = 0
		ELSE
			LET Mode = 1	'AC by default
		ENDIF
	ENDIF                  
	LET Allouts = Range & 7		'Keep curent range	
	LET Allouts = 16 * Mode + allouts + 128
	LET pins = Allouts
	IF Mode < 5 THEN
		PULSOUT 3,1		'Pulse the 74259 gate
	ENDIF
	LET Allouts = Range & 7	
	LET Allouts = allouts + 208	'Set meter enable now
	LET pins = Allouts
	PULSOUT 3,1			'Pulse the 74259 gate	
ENDIF
rem check if ohms switch has changed
IF pin0 = 0 AND Ohms = 0 THEN Init
IF pin0 = 1 AND Ohms = 1 THEN Init
rem loop while in range to avoid cycling lamps and meter enable
DO
	READADC10 1, Current
LOOP WHILE Current > GoDown AND Current < GoUP
GOTO main

























