#rem btTransceiver.bas for the Picaxe subassembly of the Bluetooth Transceiver
 *  The Bluetooth Transceiver is housed in a in a sealed beige plastic box. 
 *  In addition to the receiver, the box contains an Arduino Pro Mini,Nano33BLE 
 *  and two LED indicator lamps
 *  All is powered via a 5.5x2.1 coaxia;jack with 9.35V input to a 7805 regulator, .
 *  The receiver receives selected messages broadcast on the 433 MHz ISM band.
 *  After verification and buffering, the messages are forwarded to the Arduino by I2C.
 *  John Saunders  13/4/2025
#endrem 

#picaxe08M2

#rem The 08M2 has RAM addteses from 28 to 127
RAM Addresses 28- 59 store incoming RF messages
#endrem


rem --------------------------------- PORTS ----------------------------------------

rem Inputs C.1 is I2C SCL, C.2 is SDA

symbol ReceiverData	= C.3
symbol IntPort		= PinC.4

rem --------------------------------- constants ----------------------------------------
symbol buf_start = 28
symbol buf_end =   59

rem --------------------------------- Global Counters and General VARIABLES ----------------------------------------

symbol DataAddr		= b3		'Top level iteration
symbol Indx			= b4		'Second level iteration
symbol Scratch		= b5		'Use only in math. No GOSUBs while it contains valid data
symbol CharData		= b6		'Multi-use byte variable especially for ASCII data, subroutine transfer
symbol Buf_count		= b7		'Used to address an item in EEPROM


rem --------------------------------- DEDICATED VARIABLES ----------------------------------------

rem dedicated global
symbol cmdVal		= b8		'For message=KeyCode,Command=c,Disp;ay=D,Errors=E & F		

rem --------------------------------- INTERRUPT VARIABLES ----------------------------------------
symbol MsgEndAddr		= b13
symbol MsgLenChar		= b14
symbol BuffAddr		= b15
symbol KeyCode		= b16
symbol IntScratch		= b17
symbol ChckSum		= b18
symbol ChckHex		= b19
symbol RcvrCnt		= b20
symbol RcvrHex		= b21

Init:
SETFREQ m16
HI2Csetup I2CMASTER,0x0E,I2Cslow_8,I2Cbyte
Buf_count = buf_start
SETINT  %00010000,%00010000	'Interrupt when C,4 high

Main:
POKE Buf_count, 32		'space
INC Buf_count
IF Buf_count >= buf_end THEN
	Buf_count = buf_start
ENDIF
GOTO main


Interrupt:
LET bptr = buf_start + 4		
LET KeyCode = 0
LET IntScratch = 0
DO WHILE IntPort = 1 AND IntScratch < 60 
	LET IntScratch = IntScratch + 1
LOOP 		'There is a 10 ms gap before the code to allow the serin to execute
IF IntScratch < 10 OR IntScratch > 55 THEN NotMine 
SERIN [60],ReceiverData,N2400_16,("14L1776"),KeyCode,IntScratch,MsglenChar,IntScratch,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc, @bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc
IF KeyCode > "m" AND KeyCode <= "z" THEN		'A data mesage	
	IF MsgLenChar < 61 OR MsgLenChar > 81 THEN NotMine
	LET RcvrCnt = MsgLenChar - 61		
	LET ChckSum = 0
	LET bptr = buf_start + 4		
	FOR IntScratch = 0 TO RcvrCnt
		LET   ChckSum = ChckSum + @bptrinc
	NEXT
	LET ChckHex = ChckSum / 16
	IF ChckHex < 10 THEN
		LET ChckHex = ChckHex+ "0"
	ELSE
		LET ChckHex = ChckHex + "7"
	ENDIF
	LET bptr = bptr + 1
	LET RcvrHex = @bptrinc
	IF ChckHex <> RcvrHex THEN
		GOTO NotMine
	ENDIF
	LET ChckHex = ChckSum & $F
	IF ChckHex < 10 THEN
		LET ChckHex = ChckHex + "0"
	ELSE
		LET ChckHex = ChckHex + "7"
	ENDIF
	LET RcvrHex = @bptr
	IF ChckHex <> RcvrHex THEN
		GOTO NotMine
	ENDIF
	LET  MsgEndAddr = bptr - 2
	LET BuffAddr = buf_start + 2
	POKE BuffAddr, KeyCode, ","
ENDIF
IF KeyCode = "O" THEN
	LET BuffAddr = buf_start + 2
	POKE BuffAddr, "O", ",", MsgLenChar, ","
	LET  MsgEndAddr = buf_start + 6
ELSEIF KeyCode >= "0" AND KeyCode < "n" THEN	
	LET BuffAddr = buf_start + 2
	POKE BuffAddr, KeyCode, ","
	LET  MsgEndAddr = buf_start + 4
ENDIF
HIGH C.0
POKE Buf_start,"<",","
POKE MsgEndAddr, ">"," "," "," "," "
LET bptr = Buf_start
HI2COUT Buf_start, (@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptr)
NotMine:
LOW C.0
SETINT  %00010000,%00010000	'Interrupt when C,4 high
RETURN



