#rem
DenPowerController.bas
This is a black box with two 3-way min toggle switches and a red LED at one end
It has 2 independent functions with a common harness connector and 16-pin header.
The upper function controls the spotlight recessed into the top of the upper half of the Den recess, 
     It goes to a box with a 9V  relay of 180 ohm coil. The circuit puts a 62 ohm resistor in series.
     There is also a hidden microwave motion detector which emits a 2-second 3V positive pulse.
The lower function controls 7 receptacles with a 11V relay of 250 ohm coil.
     An 8th receptacle has a current-sensing transformer in series. 
     The circuit provides a count of (i-50)*5/9. I is AC current in MA
John saunders 4/19/2021
#endrem

#picaxe 14M2
rem Computer Peripheral and Audio/Video Declarations ----------------------
rem Outputs
symbol AVDrive		= B.0			'HIGH = 6-outlet box on
symbol AccDrive		= C.1			'HIGH = 7 switched outlets on.8th. is current sense

rem analog inputs
symbol CurrentPort   	= C.4		'Measures computer current	'
symbol ThresholdPot     = B.1		'Controls the current below which turnoff occurs

rem switches, action=LOW
symbol AVOn			= bit2	'B.3
symbol AVOff		= bit3	'B.4

rem variables
symbol Running		= bit5
symbol current		= b1		'Output of current sensor
symbol ThresholdAdj	= b3		'Output of lower pot adjusts current threhold
symbol AccCount		= w11

rem constants
symbol OnThreshold	= 70		'Current to turn on Accassories and A/V
symbol AccDelay		= 1000

rem Dome Light Control Declarations ----------------------------------------
rem Outputs
symbol LightDrive		= C.2		'HIGH = dome lamp on

rem analog inputs
symbol DelayPot		= B.2		'Controls turn-off delay for dome light

rem switches, action=LOW
symbol LightOn		= bit0	'C.0
symbol LightOff		= bit1	'B.5

rem Motion detector, action = HIGH
symbol MD              = bit4	'C.3	'Motion Detector-controlled dome light in auto

rem variables
symbol lightAdj		= b2		'Output of top pot adjusts light ON time 10 sec - 10 min
symbol lightCount		= w13
symbol lightLimit		= w12

rem constants
symbol lightScale		= 16		'1000*'(maxTime/256)/loopDelay
symbol minTime		= 10		'Minimum light ON time in seconds
symbol maxTime		= 600		'Maximum light ON time
symbol maxCount		= 4150	'255*lightScale + minCount, less than 65535
symbol minCount		= 68		'1000*minTime/loopDelay

rem general
symbol loopDelay		= 147		'millisec
symbol scratch		= b8

init:
SETFREQ m4
LOW LightDrive
LOW AVDrive
LOW AccDrive
LET lightCount = 0
LET AccCount = 0
LET Running = 0
PAUSE 200

main:
PAUSE loopDelay
rem MacMini Current controls both the 8-outlet box for Computer Peripherals 
rem and the 6-outlet box for Audio/Video equipmentin auto
READADC CurrentPort,current
READADC ThresholdPot,ThresholdAdj

IF current >= OnThreshold THEN
	LET Running = 1
	LET AccCount = AccDelay
ENDIF
IF current <= ThresholdAdj THEN
	IF AccCount > 0 THEN
		DEC AccCount
	ELSE
		Running = 0
	ENDIF
ENDIF
rem Computer Accessories control. Controlled by current
IF Running = 0 THEN
	LOW AccDrive
ELSE
	HIGH AccDrive
ENDIF

rem Audio/Video control. Controlled by current in auto
LET AVOn  = pinB.3
LET AVOff = pinB.4
IF AVOn = 0 THEN
	HIGH AVDrive
ELSEIF AVOff = 0 THEN
	LOW AVDrive
ELSE							
	IF Running = 0 THEN
		LOW AVDrive		
	ELSE
		HIGH AVDrive		
	ENDIF
ENDIF

rem Dome Light Control
LET lightOn  = pinC.0
LET lightOff = pinB.5
LET MD       = pinC.3
IF lightOn = 0 THEN
	HIGH lightDrive
	LET lightCount = 0
ELSEIF lightOff = 0 THEN
	LOW lightDrive
ELSEIF MD = 1 AND lightCount > minCount THEN
	HIGH lightDrive
	LET lightCount = 0
ELSE
	INC lightCount
	IF lightCount > maxCount THEN
		LET lightCount = maxCount 
	ENDIF
	IF lightCount >= minCount THEN
		READADC DelayPot,lightAdj
		LET lightLimit = lightCount - minCount
		LET lightLimit = lightLimit/lightScale
		IF lightLimit <= 255 THEN
			LET scratch = lightLimit
		ELSE
			LET scratch = 255
		ENDIF
		IF scratch >= lightAdj THEN
			LOW lightDrive
			LET lightCount = 0 
		ENDIF
	ENDIF
ENDIF		
GOTO main

