/* FMRadio.ino This is for the 1950's box which originally contained an AM radio.
 * It retains the original appearance, the tuning variable capacitor, the volume
 * with ON/OFF switch potntiometer,and the speaker.
 * This now is based on the Si4703 FM radio chip maunted on a breakout board from SparkFun.
 * There are two boards. The first measures the tuning capacitor using a NE555 oscillator whose
 * output is integrated to a DC voltage by a TLC2252 dual op-amp.  
 * The second board contains the receivera and speaker amplifier.
 * The Si4703 communicates with a SparkFun Minipro arduino via I2C.
 * The Minipro also measures the battery voltage, tuning and volume voltages.
 * The speaker amplifier is based on a LM383.
 */
#include <Si4703_Breakout.h>
#include <Wire.h>
#define SPAN 2.15       //For converting the tuning count to FM 100KHZ channel
#define BASE 1149       //For converting the tuning count to FM 100KHZ channel
int resetPin = 2;
int VOLPIN = A1;
int TUNEPIN = A2;
int BATTPIN = A3;
int SDIO = A4;
int SCLK = A5;

Si4703_Breakout radio(resetPin, SDIO, SCLK);
int channel;
int volume;
char rdsBuffer[10];       //Not used
float channelMult;
int tuneCmd;
 
void setup()
{
  Serial.begin(9600);
  radio.powerOn();
  float battVolt;
  int battRaw = analogRead(BATTPIN);
  battVolt = battRaw * 3.3 / 512; //Its a 3.3V Minipro.
  channelMult = SPAN/battVolt;   //Tuning voltage is proportional to battery voltage 
}

void loop()
{
  int volVal;
  static int prevTuning;
  int tuneRaw = analogRead(TUNEPIN);
  if (abs(tuneRaw - prevTuning) > 2) {
    prevTuning = tuneRaw;
    tuneCmd = BASE - (channelMult * tuneRaw); //The AM dial rotation is proportional to wavelenght
    volVal = analogRead(VOLPIN);
    volume = volVal/64;           //The Si4703 volume range is 0-15
    radio.setChannel(tuneCmd);
    radio.setVolume(volume);
    displayInfo();                //Only during development
    } 
    /*
      Serial.println("RDS listening");
      radio.readRDS(rdsBuffer, 15000);
      Serial.print("RDS heard:");
      Serial.println(rdsBuffer); 
      radio.setVolume(volume);     
    */
}

void displayInfo()
{
   Serial.print("Channel:"); Serial.print(tuneCmd); 
   Serial.print(" Volume:"); Serial.println(volume); 
}
