#include <NHD_US2066SDI.h>
#include <Wire.h>
#include <ds3231.h>
#define SET_B 6
#define UP_B 5
#define DOWN_B 4
#define settingsMax 6
ts t; //ts is a struct findable in ds3231.h
const char months[40] = {"JANFEBMARAPRMAYJUNJLYAUGSEPOCTNOVDEC"}; // 1 - 12
const char weekdays[22] = {"MONTUEWEDTHUFRISATSUN"};    // 1(MON) through 7(SUN)

char buf0[17];
char buf1[17];
bool milTime, buttonReady, buttonEvent, displayOff, settingsMode;
int settingsIndex;

uint8_t getTemp(void) {
  float degC = DS3231_get_treg();
  uint8_t degF = degC * 9. / 5. + 32;
  return degF;
}
// hour, min, zero sec, weekday,month,date,year
int maxVal[] = {59, 59, 0, 7, 12, 31, 99};
int minVal[] = {0,  0, 0, 1, 1, 1, 0};

int adjustTval(int val, int dir) {
  if (dir == 1) {         //UP
    if (val <  maxVal[settingsIndex]) {
      val ++;
    }
    else {
      val = minVal[settingsIndex];
    }
  }
  if (dir == 2) {         //DOWN
    if (val >  minVal[settingsIndex]) {
      val --;
    }
    else {
      val = maxVal[settingsIndex];
    }
  }
  return val;
}


void buttonAction(int button) {
  if (settingsMode == 0) {
    switch (button) {
      case 0:
        displayOff ^= 1;
        break;
      case 1:
        milTime = 1;
        break;
      case 2:
        milTime = 0;
        break;
    }
  }
  else {
    if (button == 0) {
      if (settingsIndex < settingsMax) {
        settingsIndex++;
      }
      else {
        settingsIndex = 0;
      }
    }
    if ((button == 1) || (button == 2)) {
      switch (settingsIndex) {
        case 0:
          t.hour = adjustTval(t.hour, button);
          break;
        case 1:
          t.min = adjustTval(t.min, button);
          break;
        case 2:
          t.sec = adjustTval(t.sec, button);
          break;
        case 3:
          t.wday = adjustTval(t.wday, button);
          break;
        case 4:
          t.mon = adjustTval(t.mon, button);
          break;
        case 5:
          t.mday = adjustTval(t.mday, button);
          break;
        case 6:
          t.year = adjustTval(t.year, button);
          break;
      }
      DS3231_set(t);
    }
  }
}

void rowDefs(int rowId) {
  int wdayIndex;
  int mdayIndex;
  wdayIndex = 3 * (t.wday - 1);
  mdayIndex = 3 * (t.mon - 1);
  int selTime;
  if ((milTime == 0) && (t.hour > 12)) {
    selTime = t.hour - 12;
  }
  else {
    selTime = t.hour;
  }
  switch (rowId) {
    case 0:
      snprintf_P(buf0, 17, PSTR("%02u:%02u:%02u %c%c%c"),
                 selTime, t.min, t.sec, weekdays[wdayIndex], weekdays[(wdayIndex + 1)], weekdays[(wdayIndex + 2)]);
      break;
    case 1:
      snprintf_P(buf1, 17, PSTR("%c%c%c %02u %04u %03u%c"),
                 months[mdayIndex], months[(mdayIndex + 1)], months[(mdayIndex + 2)], t.mday, t.year, getTemp(), 'F');
      break;
    case 2:
      snprintf(buf0, 2, " ");

      break;
    case 3:
      snprintf(buf1, 2, " ");
      break;
    case 4:
      snprintf(buf1, 17, "24-hour mode set");
      break;
    case 5:
      snprintf(buf1, 17, "12-hour mode set");
      break;
    case 6:
      snprintf(buf1, 17, "Hour setting");
      break;
    case 7:
      snprintf(buf1, 17, "Minute setting");
      break;
    case 8:
      snprintf(buf1, 17, "Zero seconds");
      break;
    case 9:
      snprintf(buf1, 17, "Set day-of-week");
      break;
    case 10:
      snprintf(buf0, 17, "Month setting");
      break;
    case 11:
      snprintf(buf0, 17, "Date setting");
      break;
    case 12:
      snprintf(buf0, 17, "Year setting");
      break;
  }
}

void setup ()
{
  delay(50);
  pinMode(3, INPUT);                       //1 Hz, red wre
  pinMode(DOWN_B, INPUT_PULLUP);               //Down button, yellow wre
  pinMode(UP_B, INPUT_PULLUP);               //Up button, green wre
  pinMode(SET_B, INPUT_PULLUP);               //Set button, white wre
  pinMode(RES, OUTPUT);
  digitalWrite(RES, HIGH);
  pinMode(CS, OUTPUT);
  digitalWrite(CS, LOW);
  if (digitalRead(SET_B) == 0) {
    settingsMode = 1;
  }
  else {
    settingsMode = 0;
  }
  settingsIndex = 0;
  init_oled();
  pinMode(2, OUTPUT);
  digitalWrite(2, HIGH);                //Marker to sync scope
  delayMicroseconds(3);
  digitalWrite(2, LOW);
  milTime = 1;
  buttonReady = 1;
  buttonEvent = 0;
  displayOff = 0;
  Wire.begin(); //start i2c (required for connection)
  DS3231_init(DS3231_INTCN); //register the ds3231 (DS3231_INTCN is the default address of ds3231, this is set by macro for no performance loss)
}

void loop ()
{
  //  Serial.begin(9600);
  bool pastEnd;
  if ((digitalRead(SET_B) == 1) && (digitalRead(UP_B) == 1) &&  (digitalRead(DOWN_B) == 1)) {
    buttonReady = 1;
  }
  if (buttonReady == 1) {
    if (digitalRead(SET_B) == 0) {
      buttonReady = 0;
      buttonAction(0);
    }
    if (digitalRead(UP_B) == 0) {
      buttonReady = 0;
      buttonAction(1);
    }
    if (digitalRead(DOWN_B) == 0) {
      buttonReady = 0;
      buttonAction(2);
    }
  }
  DS3231_get(&t); //get the value and pass to the function the pointer to t
  if (settingsMode == 0) {
    if (displayOff == 1) {
      rowDefs(2);
      rowDefs(3);
    }
    else {
      if (digitalRead(UP_B) == 0) {
        rowDefs(4);
        rowDefs(1);
      }
      else {
        if (digitalRead(DOWN_B) == 0) {
          rowDefs(5);
          rowDefs(1);
        }
        else {
          rowDefs(0);
          rowDefs(1);
        }
      }
    }
  }
  else {
    switch (settingsIndex) {
      case 0:
        rowDefs(6);
        rowDefs(0);
        break;
      case 1:
        rowDefs(7);
        rowDefs(0);
        break;
      case 2:
        rowDefs(8);
        rowDefs(0);
        break;
      case 3:
        rowDefs(9);
        rowDefs(0);
        break;
      case 4:
        rowDefs(1);
        rowDefs(10);
        break;
      case 5:
        rowDefs(1);
        rowDefs(11);
        break;
      case 6:
        rowDefs(1);
        rowDefs(12);
        break;
      default:
        rowDefs(0);
        rowDefs(1);
        break;
    }
  }
  pastEnd = 0;
  for (int i = 0; i < 16; i ++ ) {
    if ( pastEnd == 1) {
      buf0[i] = ' ';
    }
    if (buf0[i] < ' ') {
      pastEnd = 1;
      buf0[i] = ' ';
    }
  }
  pastEnd = 0;
  for (int i = 0; i < 16; i ++ ) {
    if ( pastEnd == 1) {
      buf1[i] = ' ';
    }
    if (buf1[i] < ' ') {
      pastEnd = 1;
      buf1[i] = ' ';
    }
  }
  command(0x80);
  delay(2);
  for (int i = 0; i < 16; i ++ ) {
    data(buf0[i]);
  }
  command(0xA0);
  delay(2);
  for (int i = 0; i < 16; i ++ ) {
    data(buf1[i]);
  }
  delay(100);

}
