#rem
LED_Driver.bas	Provides 20-90 constant current at up to 24 V
John Saunders 3/1/2014
#endrem

#picaxe 08M2

rem inputs:
symbol Temp_Port  = C.1		'Measures the heat sink temperature
symbol Volt_Port  = C.4		'Measures the 1.25V regulated of the LM317


rem outputs
symbol LED_Port   = C.2		'High turns on the output

rem variables
symbol Thermister = b1
symbol Reg_Volts  = b2
symbol Minute_Count = w7
symbol Second_Count = b3

rem constants
symbol Min_volts  = 30
symbol Hour_Count = 239
symbol Fudge      = 19

init:
SETFREQ m4
LOW LED_Port
LET Minute_Count = 0
LET Second_Count = 58
LOW C.0

main:
READADC Volt_Port,Reg_Volts
IF Reg_Volts < Min_Volts THEN
	LET Minute_Count = 0
	LET Second_Count = 0
	HIGH LED_Port
ENDIF
PAUSE 997
INC Second_Count
IF Second_Count >= 60 THEN
	LET Second_Count = 0
	INC Minute_Count
	IF Minute_Count < Hour_Count THEN
		HIGH LED_Port
	ELSE
		LOW LED_Port
	ENDIF
	IF Minute_Count >= 1440 THEN
		LET Minute_Count = 0
	ENDIF
	PAUSE Fudge
	LET w5 = Reg_Volts * 195
	LET w5 = w5/100
'	SERTXD ("Volts=",#w5,",Count=",#Minute_Count,13,10)
PULSOUT C.0,10
ENDIF
GOTO main