#rem mechanicalCounter.bas for the counter and its driver in the transparent box.
Use only powered by the marked 18V supply with 5,5x2,5 coax connector.
The 3.5mm stereo audio jack has two connections.
The tip is connected to the 5V regulator, and can supply up to 160MA.
The ring is the trigger input:
With jumper to front counts on a positive pulse, positive-going edge 2-6V, 4.7K to ground
With jumper to rear counts on making contact to ground, has 4.7 K pullup to +5V.
Minimum pulse length 2ms, maximum unlimited.
John Saunders 4/23/2022
#endrem
#picaxe 08M
rem ports
symbol ctrDrive	= 1
symbol LEDport	= 2
symbol modePort	= pin3
symbol intPort	= pin4
rem variables
symbol intState	= bit0
symbol mode		= w2
rem constants
symbol pulseLen	= 20
symbol inhibit	= 80

setup:
SETFREQ m4
OUTPUT ctrDrive
LOW ctrDrive
OUTPUT LEDport
LOW LEDport
IF modePort = 0 THEN			'Jumper to front. positive pulse
	LET mode = %00010000
ELSE
	LET mode = %00000000
ENDIF
SETINT mode,%00010000

main:
PAUSE 1
GOTO Main

interrupt:
HIGH ctrDrive
HIGH LEDport
PAUSE pulseLen
LOW ctrDrive
PAUSE inhibit
LOW LEDport
rem Wait for the end of a long trigger to avoid multiple interrupts
IF mode = 0 THEN
	DO
		LET intState = intPort
			SERTXD (",",#intState)
	LOOP WHILE intState = 0
	SERTXD (13,10)
ELSE 
	DO
		LET intState = intPort
		SERTXD (",",#intState)
	LOOP UNTIL intState = 0
	SERTXD (13,10)	
ENDIF
SETINT mode,%00010000
RETURN