/*
 * Mobile_Display.h
 * Contains only type definitions and declarations and fixed data
 */
 
 /*****************************************************************
 * initParams: Declaration of the black magic commands to initialize the display.
 * Each is implemented as a separate 2-byte I2C session, or its does not work right
 * Since these are unsigned ints, the ones showing a single byte are preceded by an 0x00 byte.
 */                         
const  unsigned int initParams[] =
  {   0x2A //function set A
    , 0x71 //
    , 0x4000 // Internal regulator disabled
    , 0x28 //function set (fundamental command set)
    , 0x08 //Display,cursor,blink all off
    , 0x2A //2 line normal display
    , 0x79 //OLED command set enabled
    , 0xD5 //Set clock ratio
    , 0x70 //Osc highest, disp lowest (default)
    , 0x78 //OLED command set disabled
    , 0x08 //6-dot font width, 2 lines
    , 0x06 //Entry mode cursor shift right
    , 0x72 //function selection B
    , 0x4000 //Character table A
    , 0x2A //function set (extended command set)
    , 0x79 //OLED command set enabled
    , 0xDA //Set SEG pins
    , 0x00 //default
    , 0xDC //function selection C
    , 0x00 //Set Vsel & GPIO (internal, disabled)  
    , 0x81 //Set contrast
    , 0x7F //Full brightness (default)
    , 0xD9 //Set phase length
    , 0xF1 //Phase periods: 15,1(default0x87)
    , 0xDB //set VCOMH deselect level
    , 0x40 //1xVcc(default 0x20, 0.77Vcc
    , 0x78 //OLED command set disabled
    , 0x28 //fundamental command set 2 lines, normal height
    , 0x01 //clear display
    , 0x80 //Home cursor
    , 0x0C //Display on, cursor off, blink off}
   };

void posESC(int,int); 

/*****************************************************************
 * jump_t Definition of the logic for transitions between pages.
 * Does not include any definition of actions to be taken on entry,duration, or exit
 */
typedef struct {
  byte toVal;           // in 0.5 sconds
  byte toJump;          // page on timeput, 84 is power turnoff
  byte redJump;         // page on red button, 88 no jump
  byte yelJump;         // page on yellow button, 88 no jump
} jump_t;

  /*****************************************************************
   * jumpTable Th1s arrays implements the transitions of the State Diagram. See State Diagram.jpg
   * The index is page number.
   * The first array is the timeout in half-seconds which is set on entry to the page
   * The second is the page number to jump to on timeout.
   * The third is the page number to jump to on red button or "X" for no-op
   * The third is the page number to jump to on yellow button or "X" for no-op
   * 84 is special for turnoff. 
   * 66 is special for 0-3 depending og units and pressure presentation as follows
   * UnitType:  138     139     138       139
   * pressType  130     130     140       140
   * page         0       1       2         3
   */
const static jump_t  jumpTable[] = {
// page  0         1         2           3          4             5
  {60,4,5,4},{60,4,5,4},{60,4,5,4},{160,4,5,4},{60,84,66,5},{60,4,7,4},
//     6           7             8           9            10          11
  {50,7,88,88},{60,4,9,6},{50,9,88,88},{60,4,11,8},{50,11,88,88},{60,4,13,10},
//      12          13           14         15
  {50,13,88,88},{60,4,15,12},{50,15,88,88},{60,4,5,14}
};

 /*****************************************************************
 * page_t: Definition of the content and placement of a field on the display. 
 * Format is a code with several meanings
 */
typedef struct {
  byte row;
  byte column;
  byte format;
  }
 page_t;


//  page_t.format: The format code values are:
// 0-13: RTC Converts the corresponding entry in rtcInts[] to alpha
// 14: convert rtcInts[7] to 3-character string. 1=Monday
// 15: convert rtcInts[10,11]to 3-character month string.1=January
// 16: converts the compass angle to the intermediate point 2-character sring
// 17: substitutes the string index in pressType to display as a string
// 18: substitutes the string index in unitType to display as a string
// 33-129 : literal printable single characters
// 130-150: index for strings. Declared in pagexx[]
// 200-209: index for values. Declared in sketch in valInts[] and filled in br xxGet() functions


/*****************************************************************
 * strPage: An array of strings which appear on the display. Codes 130 - 150, extendable
 * Put here to avoid duplication. Referenced in pages_t.format by adding 130 to the index
 */
//                           0      1      2        3          4      5       6      7     8      9
const  char  *strPages[]  = {"Alt","Temp=","Hum=","Battery=","Back","Next","Setup","Edit","US","Metric",
   "Baro","Correction","Hour","Minute","Adjust","Units","Select","UP","Down","Readout","Pressure"};
//   10        11        12      13       14      15       16      17    18      19        20

/*****************************************************************
 * strDays: Put into page 4 with format 14. Index calculated mathemativally from RTC value
 */
const  char strDays[]   = {"MonTueWedThuFriSatSun"};

/*****************************************************************
 * strMonths: Put into page 4 with format 15. Index calculated mathemativally from RTC value
 */
const  char strMonths[] = {"JanFebMarAprMayJunJulAugSepOctNovDec"};

/*****************************************************************
 * strOctant: Put into pages 0-3 with format 16. Index calculated mathemativally from compass angle
 */
const  char *strOctant[] = {"NE"," E","SE"," S","SW"," W","NW"," N"};
/*****************************************************************
 * strDiag: Sebd to Serial line 3
 */
const  char strDiag[] = {"Page=   TO=      "};

/*****************************************************************
 * values: Definition of numerical fields fields of each page. 
 * Since values.val is a variable, instances of values are declared on the sketch
 */
typedef struct  {
  int val;            // The number to be displayed, a signed int
  byte digits;        // The number of significant digits to be displayed (less leading 0)
  byte places;        // The number of significnt gigits after the decimal point
} values;

/*****************************************************************
 * pagexx[]: Declaraions of the contents fields of each of the 16 pages. See Layout.xls
 * Any location not covered remains a space character
 */

const static page_t page00[] = {
    { 0,  0, 130}, { 0,  3, '='}, { 0,  4, 200}, { 0, 10, 'F'},
    { 0, 11, 't'}, { 0, 14,  16}, { 1,  0, 131}, { 1,  5, 201},
    { 1, 10,0x80}, { 1, 11, 'F'}, { 1, 13, 202}, { 1, 15, '%'},
    { 2, 16, 253}
};
const static page_t page01[] = {
    { 0,  0, 130}, { 0,  3, '='}, { 0,  4, 205}, { 0, 9, 'M'},
    { 0, 14,  16}, { 1,  0, 131}, { 1,  5, 206}, { 1, 10,0x80}, 
    {1, 11, 'C'},  { 1, 13, 202}, { 1, 15, '%'}, { 2, 16, 253}
};
const static page_t page02[] = {
    { 0,  0, 140}, { 0,  4, '='}, { 0,  5, 207}, { 0, 10, '"'},
    { 0, 11, 'H'}, { 0, 12, 'g'}, { 0, 14,  16}, { 1,  0, 131},
    { 1,  5, 201}, { 1, 10,0x80}, { 1, 11, 'F'}, { 1, 13, 202},
    { 1, 15, '%'}, { 2, 16, 253}
};
const static page_t page03[] = {
    { 0,  0, 140}, { 0,  4, '='}, { 0,  5, 208}, { 0, 12, 'k'}, 
    { 0, 13, 'P'}, { 0, 14, 'a'}, { 1,  0, 131},
    { 1,  5, 206}, { 1, 10,0x80}, { 1, 11, 'C'},  { 1, 13, 202},
    { 1, 15, '%'}, { 2, 16, 253}
};
const static page_t page04[] = {
    { 0,  0,   4}, { 0,  1,   5}, { 0,  2, ':'}, { 0,  3,   2},
    { 0,  4,   3}, { 0,  5, ':'}, { 0,  6,   0}, { 0,  7,   1},
    { 0, 13, 203}, { 1,  0,  14}, { 1,  4,  15}, { 1,  8,   8},
    { 1,  9,   9}, { 1, 10, '/'}, { 1, 11, '2'}, { 1, 12, '0'},
    { 1, 13,  12}, { 1, 14,  13}, { 2, 16, 253}
};
const static page_t page05[] = {
    { 0,  0, 134}, { 0,  5, 136}, { 0, 12, 135}, { 1,  0, 133},
    { 1,  8, 204}, { 1, 12, 'V'}, { 2, 16, 253}
    };
const static page_t page06[] = {
   {0,0,130},{0,5,17},{0,12,140},{ 1,0,150},{ 1,9, 149},{ 3,17, 254}
};
const static page_t page07[] = {
  { 0,0,137},{ 0,12,135},{ 1,0,146},{ 1,7,130},{1,10,'/'},
  {1,11,140},{1,15,'?'},{ 2,16,253}
};
const static page_t page08[] = {
   { 0,0,148},{ 0, 5,200},{ 0,14,147},{ 1,0,140},{ 1,5,141},{ 2,16,253}
};
const static page_t page09[] = {
   {0,0,137},{0,12,135},{1,0,140},{1,5,141},{2,16,253} 
};
const static page_t page10[] = {
   { 0,0,148},{ 0,6,4},{ 0,7,5},{ 0,14,147},{ 1,0,142},{ 1,5,144},{ 1,13,203},{ 2,16,253}
};
const static page_t page11[] = {
    { 0,0,137},{ 0,6,4},{ 0,7, 5},{ 0, 12,135},{ 1,0,142},{1, 5,144},{ 1,13,203},{ 2,16,253}
};
const static page_t page12[] = {
   { 0,0,148},{ 0,6,2},{ 0,7,3},{ 0,14,147},{ 1,0,143},{1,7,144},{ 2,16,253}
};
const static page_t page13[] = {
   { 0,0,137},{ 0,6,2},{ 0,7,3},{0,12,135},{ 1,0,143},{ 1,7,144},{ 2,16,253}
};
const static page_t page14[] = {
   {0,0,138},{ 0,5,18},{0,10,139},{ 1,0,145},{ 1,6,18},{ 1,13, 203},{ 3,17, 254}    
};
const static page_t page15[] = {
    { 0,0,137},{ 0,12,134},{ 1,0,146},{ 1,7,145},{1,12,'?'},{ 2,16,253}
    };


/*****************************************************************
 * pages[]: Declaration of an array of pointers to the page declarations
 */
page_t *pages[] = {
  page00, page01, page02, page03,page04, page05, page06, page07,
  page08, page09, page10, page11,page12, page13, page14, page15
};
