#rem OLEDLogger.bas for the Picaxe subassembly of the OLED Logger INSTALLED 11/1/2022
The OLED Logger is housed in a metal clamshell case. 
 *  The top is cream-colored and has a 20-column by 4 row blue OLED character display, and a 5-button rosette,
 *  It connects to the brown base by a ribbon cable.
 *  The base has three sub-assemblies: Power, Signal Conditioning, and Data Processing.
 *  The Power sub-asembly has a 3400 MAH Li-Ion cell which can power the Logger for 11 hours down to 3.5V.
 *  It has a switch-mode charger annd a switch-mode booster with a 6.5V regulated output.
 *  The recommended charging power supply is the Challenger 12V, 3A with 2 pigtails.
 *  When the battery is fully charged, the power consimption is 1.2W.
 *  The Signal Conditioner sub-assembly used a Picaxe 28X2. It converts analog inputs to ASCII in volts.
 *  There are three sets of inputs:
 *  1. Power Monitoring: (S)upply (charging voltage and (C)ell battery voltage. Key n
 *  2. Rear panel: 3 jacks (G)reen, (B)lue and (O)range have 3 switched ranges: Up=28V,Center=52V,Down=12V.
 *     (W)hite jack is direct 2V key m. Scaling is corrected in the conversion. A 4.096V reference is used.
 *  3. RF signals via 9-pin male jack. These are already digitized. keys p through z
 *  The Data Processor uses an Arduino UNO with a logger shield, which also has a real-time clock-calendar.
 *  It lowers the 6.5V input to 5V for everything. The Logger can also be powered via the UNO USB jack.
The board converts the inputs to ASCII in engineering units and stores them.
They are output in two messages to the Arduino by HSEROUT on command.
The RF messages are output to the Arduino by HSEROUT when received
John Saunders 1/4/2022 pairs with OLEDLogger.ino 16 mHz interrupt & hserout
10/3/22 added rx buffering and used scratchpad for both measurement and Rx buffering
10/10/22 lower limit for rcvr count. 10/11/2022 interrupt - 1 not - 2,11/1/2022 interrupt no =1
Program running 9/22
#endrem 
#picaxe28X2
#rem
28X2 resources: bits 0-31, bytes 2 - 55, words 1 - 27
SRAM 56-255, can use @bptr. 
Scratchpad 0-1023, can use @ptr
EEPROM 0-255
#endrem

#rem
RAM Addresses 54-80 store incoming RF messages

Scratchpad memory usage:
Addresses 0-49 are reserved for automatic incoming commands from the Arduino
Addresses 50-85 contain an analog 4-character value complete with ID, decimal point in ASCII and commas
Addresses 130 - 165 is the main buffer for incoming messages
Addresses 170 - 205 is the alternate buffer for incoming messages
#endrem


rem --------------------------------- PORTS ----------------------------------------

rem Inputs

symbol ReceiverData	= C.1
symbol IntPort		= PinC.2
symbol DTR			= pinC.3

rem Outputs

symbol RTS			= C.0
symbol trace		= A.4


rem --------------------------------- Flags triggering a transmission --------------------------------------

symbol newArdCmd		= bit0	'An incoming arduino command is in scratchpad addreess 0
symbol measReady		= bit1	'A measurement is stored in RAM at measStartAddr
symbol rx1Flag		= bit2	'An RF message has been stored inat rxBuf1addr
symbol rx2Flag		= bit2	'An RF message has been stored inat rxBuf2addr

rem --------------------------------- COUNTER AND General VARIABLES ----------------------------------------

symbol Iter			= b3		'Top level iteration
symbol Indx			= b4		'Second level iteration
symbol Scratch		= b5		'Use only in math. No GOSUBs while it contains valid data
symbol CharData		= b6		'Multi-use byte variable especially for ASCII data, subroutine transfer
symbol DataAddr		= b7		'Used to address an item in EEPROM


rem --------------------------------- DEDICATED VARIABLES ----------------------------------------

rem dedicated global
symbol cmdVal		= b11		'For message=KeyCode,Command=c,Disp;ay=D,Errors=E & F		
symbol dispVal		= b12		'For message=Msglen,else KeyCode
symbol ardCmd		= b13		'A command from the arduino.
symbol analogIndex	= b14		'Index into entries in the table starting at AnalogTableAddr
symbol scale		= b15	
symbol measStep		= b16		'Steps in measuring an analog value
symbol flagID		= b17
symbol flagData		= b18

rem --------------------------------- STORE ANALOG SUBPROGRAM VARIABLES ----------------------------------------
symbol Aref			= b19
symbol Channel		= b20
symbol Multiply		= b21
symbol Divide		= b22
symbol Decimals		= b23
symbol AccumuVal		= w12		'Multiplication word variable
symbol RawVal		= w13		'Analog measurement
symbol Thous		= b28
symbol Huns			= b29
symbol Tens			= b30
symbol Units		= b31

rem --------------------------------- INTERRUPT VARIABLES ----------------------------------------

symbol IntCode0		= b41
symbol IntCode1		= b42
symbol spAddr		= b43		
symbol KeyCode		= b44
symbol IntScratch		= b45
symbol Msglen		= b46
symbol ChckSum		= b47
symbol ChckHex		= b48
symbol RcvrCnt		= b49
symbol RcvrHex		= b50

rem --------------------------------- Constants ----------------------------------------

symbol analogTableAddr  = 0		'In EEPROM
symbol ADCpause		= 8
symbol rcvrStartAddr	= 54		'InRAM
symbol measStartAddr	= 50		'In scratchpad
symbol rxBufaddra		= 130		'In scratchpad
symbol rxBufaddrb		= 170		'In scratchpad
symbol ardCmdAddr		= 0

rem --------------------------------- EEPROM ----------------------------------------

rem analog calculation constants in order of AnalogIndex.

rem    ADC Channel Aref          Multiply   Divide      Decimals    
DATA 0,( 	 0,	FVR4096,		26,         5,        	2)    'Green jack. 52V     
DATA 5,( 	 0,	FVR4096,		14,         5,       	2)    'Green jack. 28V 
DATA 10,( 	 0,	FVR4096,		12,        10,        	2)  	'Green jack. 12V 
DATA 15,( 	13,	FVR4096,		26,         5,       	2)  	'Blue jack. 52V
DATA 20,( 	13,	FVR4096,		14,         5,        	2)	'Blue jack. 28V	
DATA 25,( 	13,	FVR4096,		12,        10,        	2)  	'Blue jack. 12V  
DATA 30,( 	12,	FVR4096,		26,         5,        	2)  	'Orange jack 52V
DATA 35,( 	12,	FVR4096,		14,         5,        	2)  	'Orange jack 28V
DATA 40,( 	12,	FVR2048,		12,         2,        	3)  	'Orange jack 6V
DATA 45,( 	 2,	FVR2048,		10,         5,        	3)  	'White jack 2V
DATA 60,( 	 3,	FVR4096,		10,		5,	    	2)	'Supply Voltage 20V
DATA 75,( 	 1,	FVR4096,		10,		2,	    	3)	'Battery Voltage 5V

Init:
SETFREQ m8
HSERSETUP B57600_8,$001
LET hserinflag = 0
LET hserptr = ardCmdAddr
LET measStep = 0
LET b0	  = 0
LET ptr = 0
LET ADCSETUP = %0011000000001111
LOW RTS
LOW trace

SETINT  %00000100,%00000100	'Interrupt when C,2 high

Main:
IF newArdCmd = 1 THEN
	IF ardCmd = "m" THEN			
		LET spAddr = measStartAddr
		PUT spAddr,"<","q",","
		LET spAddr = spAddr + 3	
		FOR analogIndex = 0 TO 1
			LET measStep = 0		
			GOSUB StoreAnalog
		NEXT 
		DEC spAddr
		PUT spAddr, ">"
		LET measReady = 1
	ENDIF
	IF ardCmd = "o" THEN
		LET spAddr = measStartAddr
		PUT spAddr,"<","y",","
		LET spAddr = spAddr + 3
		FOR analogIndex = 2 TO 3
			LET measStep = 0		
			GOSUB StoreAnalog
		NEXT 
		DEC spAddr
		PUT spAddr, ">"
		LET measReady = 1
	ENDIF
	IF ardCmd = "n" THEN
		LET spAddr = measStartAddr
		PUT spAddr,"<","t",","
		LET spAddr = spAddr + 3
		FOR analogIndex = 4 TO 5
			LET measStep = 0		
			GOSUB StoreAnalog
		NEXT 
		DEC spAddr
		PUT spAddr, ">"
		LET measReady = 1
	ENDIF
	LET newArdCmd = 0
	LET ardCmd = " "
ENDIF

IF rx1Flag = 1 THEN
	LET spAddr = rxBufaddra
	DO
		GET spAddr,CharData
		HSEROUT 0,(CharData)
		INC spAddr
	LOOP WHILE CharData <> ">"
	LET rx1Flag = 0
ENDIF

IF rx2Flag = 1 THEN
	LET spAddr = rxBufaddrb
	DO
		GET spAddr,CharData
		HSEROUT 0,(CharData)
		INC spAddr
	LOOP WHILE CharData <> ">"
	LET rx2Flag = 0
ENDIF

IF measReady = 1 THEN
	LET spAddr = measStartAddr
	DO
		GET spAddr,CharData
		HSEROUT 0,(CharData)
		INC spAddr		
	LOOP WHILE CharData <> ">"
	LET measReady = 0
ENDIF

PAUSE 10
IF hserinflag <> 0 THEN
	PAUSE 10
	SERTXD ("New command = ")
	GET ardCmdAddr,ardCmd
	IF ardCmd <> " " THEN
		LET newArdCmd = 1
		LET hserptr = ardCmdAddr
	SERTXD (ardCmd,13,10)
	ENDIF
	LET hserinflag = 0
	LET hserptr = ardCmdAddr
ENDIF
GOTO Main

GetTableAddr:		'Provides the address of the entry in the analog table in dataAddr
SELECT analogIndex
	CASE 0	'Green
		LET scale = pinB.6 + pinB.6 + pinB.7
	CASE 1	'Blue
		LET scale = 2*pinB.3 + pinB.4
	CASE 2	'Orange
		LET scale = 2*pinB.1 + pinB.2
	ELSE
		LET scale = 0
ENDSELECT
LET dataAddr = 3*analogIndex + scale
LET dataAddr = 5*dataAddr
RETURN


StoreAnalog:	'Input is AnalogIndex, measStep
IF measStep = 0 THEN			'Prepare for measurement
	GOSUB GetTableAddr
	READ DataAddr,Channel,aRef, Multiply,Divide,Decimals
	LET AccumuVal = 0
ENDIF

'The FVR4096 and ADCCONFIG must immediately precede a READADC command
FOR measStep = 1 TO Multiply
	FVRSETUP aRef
	ADCCONFIG %1000
	READADC10 Channel,rawVal
	LET AccumuVal = AccumuVal + rawVal
	PAUSE ADCpause
NEXT
LET AccumuVal = AccumuVal / Divide
LET CharData = "?"
LET ptr = spAddr
LOOKUP AnalogIndex,("G","B","O","W","S","C"),CharData
LET @ptrinc = CharData
LET @ptrinc =   ","
BINTOASCII AccumuVal,CharData,Thous,Huns,Tens,Units
LET @ptrinc = Thous
IF Decimals = 3 THEN
	LET @ptrinc = "."
ENDIF
LET @ptrinc = Huns
IF Decimals = 2 THEN
	LET @ptrinc = "."
ENDIF
LET @ptrinc = Tens
IF Decimals = 1 THEN
	LET @ptrinc =   "."
ENDIF
LET @ptrinc = Units
IF Decimals = 0 THEN
	LET @ptrinc =   "0"
ENDIF
LET @ptrinc = ","
LET measStep = 100
LET spAddr = ptr
RETURN



Interrupt:
HIGH trace
LET bptr = rcvrStartAddr		
LET KeyCode = "t"
LET FlagID = " "
LET IntScratch = 0
DO WHILE IntPort = 1 
	LET IntScratch = IntScratch + 1
LOOP 		'There is a 10 ms gap before the code to allow the serin to execute
IF IntScratch < 10 OR IntScratch > 200 THEN NotMine 
LET IntScratch = 0
SERIN [60],ReceiverData,N2400_8,("14L1776"),KeyCode,IntCode0,MsgLen,IntCode1,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc
IF KeyCode = "t" OR KeyCode < "0" OR KeyCode > "z" THEN NotMine
IF KeyCode = "O"  AND IntCode0 = "," THEN	
	LET KeyCode = "o"
	LET bptr = rcvrStartAddr
	LET @bptrinc = "D"
	LET @bptrinc = ","
	LET @bptr = MsgLen
	LET RcvrCnt = 4
	GOTO storeInt
ELSEIF  KeyCode < "n" THEN
	LET bptr = rcvrStartAddr 
	LET IntScratch = KeyCode	
	LET KeyCode = "o"
	LET @bptrinc = "C"
	LET @bptrinc = ","
	LET @bptr = IntScratch
	LET RcvrCnt = 4
	GOTO storeInt
ENDIF
IF KeyCode >= "n" AND KeyCode <= "z" THEN
	IF MsgLen < 61 OR MsgLen > 81 THEN NotMine
	LET RcvrCnt = MsgLen - 61		'Address of last message byte
	LET ChckSum = 0
	LET bptr = rcvrStartAddr		
	FOR IntScratch = 0 TO RcvrCnt
		LET   ChckSum = ChckSum + @bptrinc
	NEXT
	LET ChckHex = ChckSum / 16
	IF ChckHex < 10 THEN
		LET ChckHex = ChckHex+ "0"
	ELSE
		LET ChckHex = ChckHex + "7"
	ENDIF
	LET bptr = bptr + 1
	LET RcvrHex = @bptrinc
	IF ChckHex <> RcvrHex THEN
		LET FlagID = "E"
		LET FlagData = KeyCode 
		GOTO NotMine
	ENDIF
	LET ChckHex = ChckSum & $F
	IF ChckHex < 10 THEN
		LET ChckHex = ChckHex + "0"
	ELSE
		LET ChckHex = ChckHex + "7"
	ENDIF
	LET RcvrHex = @bptrinc
	IF ChckHex <> RcvrHex THEN
		LET FlagID = "F"
		LET FlagData = KeyCode 
		GOTO NotMine
	ENDIF
ENDIF
storeInt:
LET bptr = rcvrStartAddr
IF rx1Flag = 0 OR rx2Flag = 0 THEN		
	IF rx1Flag = 0 THEN
		LET spAddr = rxBufaddra
		LET rx1Flag = 1
	ELSEIF rx2Flag = 0 THEN	
		LET spAddr = rxBufaddrb
		LET rx2Flag = 1
	ENDIF
	PUT spAddr,	"<",KeyCode,","
	LET spAddr = spAddr + 3
	FOR IntScratch = 0 TO RcvrCnt
		IF @bptr < "," OR @bptr > "z" THEN
			EXIT
		ENDIF
		PUT spAddr,@bptrinc
		INC spAddr
	NEXT
	LET spAddr = spAddr		'11/1/2022
	PUT spAddr,">"
ENDIF	
GOTO noError
NotMine:
SERTXD ("Error:",FlagID,",",FlagData,13,10)
noError:
SETINT  %00000100,%00000100	'Interrupt when C,2 high
RETURN



