#rem Gate-2.bas is the program for the box fastened to the gatepost.
When the gate opens this program starts and the sense pin is high.
RF signals are sent until the gate closes, then the program exits
Jphn Saunders 8/16/2016
#endrem
#Picaxe 08M2

rem Input
symbol Gate_sense = pinC.3
rem Outputs
symbol Keep_alive = C.4
symbol Tx_Key     = C.1

rem Variables
symbol Gate_Open  = bit0
symbol Tx_Code    = b1
symbol Tx_Gap     = b2
symbol Tx_Number  = b3
symbol Iter       = b4

rem Constants
symbol Key_Open   = "Q"
symbol Key_Closed = "B"
symbol Gap_Open   = 700
symbol Gap_Closed = 1200
symbol Open_Num   = 3
symbol Closed_Num  = 2

Init:
SETFREQ m4
OUTPUT Keep_Alive
HIGH Keep_Alive
OUTPUT Tx_Key
LOW Tx_Key

Still_Open:
GOSUB Transmit
SETFREQ k31
PAUSE 65
SETFREQ m4
IF Tx_Code = Key_Open THEN Still_Open
LOW Keep_Alive
END

Transmit:
LET Gate_Open = Gate_Sense
IF Gate_Open = 0 THEN
	LET Tx_Code = Key_Closed
	LET Tx_Gap = Gap_Closed
	LET TX_Number = Closed_Num
ELSE
	LET Tx_Code = Key_Open
	LET Tx_Gap = Gap_Open
	LET TX_Number = Open_Num
ENDIF
FOR Iter = 0 TO Tx_Number
	HIGH Tx_Key
	PAUSE 20
	LOW Tx_Key
	PAUSE 10
	SEROUT Tx_Key,N2400_4,("14L1776",Tx_Code,13,10)
	PAUSE Tx_Gap	
NEXT Iter
RETURN