#rem
12_pos_rotary.bas A flat oak box. The switch is connected to non-sequential taps on a 16-resistor potentiometer.
The voltage is measured and combined with the toggle position to provide an index into a table.
The first 3 physical switch positions control the Message Display, and all have a Key Code of "O".
The table gives the Display Code less 48 to distinguish from the rest, which are Key Codes.
Legend: P=actual switch position. I - Index into the data which defines the code to transmit 
John Saunders 2015, anoted 4/24/2022
K = Key Code D = Display Code  A = action
				Up				Down
P	Label		I	D	A			I	D	A
1    GARAGE/MAH 	3	A	Garage   		2	B	Disp Charging Volts
2    TEMP/HUM	7	C	Disp Temp		6	D	Disp Humidiry
3    BARO/NIGHT	11	E	Baro,solar MA	10	F	Night-time Display


P	Label		I	K	A		I	K	A
4    HANGING	1	I	ON		0	C	OFF
5    FLOOR		5	b	ON		4	f	OFF
6    PINAPPLE	9	K	ON		8	8	OFF
7    FLASHING	13	Y	ON		12	W	OFF
8    SHELF		17	E	ON		16	F	OFF
9    CIRCLE		21	P	ON		20	l	OFF
10   BULLSEYE	15	M	ON		14	g	OFF
11   EGGS		19	d	ON		18	9	OFF
12   CEILING	23	R	ON		22	G	OFF

John Saunders 10/31/2016 added off codes for bullseye and circle
#endrem

#picaxe 08M2

rem Inputs
symbol TX_Data_Port	= B.0		'Idle low serial transmission at 2400 baud
symbol SW_Port		= C.1
symbol Toggle_Port	= PinC.3

rem Outputs
symbol Hold_Port		= C.4

rem Constants
symbol TX_Preamble	= 20		'A long pulse before the serial transmission to trigger an interrupt
symbol TX_Ser_Setup	= 10		'Gives time to execute the serial in command in the interrupt procedure
symbol Start_Count	= 40
symbol Step_Count		= 16

rem Variables
symbol ADC_Val		= b1
symbol Key_Addr		= b2
symbol Threshold		= b3
symbol Key_Code		= b4
symbol Display_Code     = b5

rem Key Code list
rem           0   1   2   3   4   5   6   7   8   9
DATA	0,    ("C","I", 2,  1 ,"f","b", 4 , 3 ,"8","K")
DATA	10,   ( 6 , 5 ,"W","Y","g","M","F","E","9","d")
DATA	20,   ("l","P","G","R")

main:
HIGH Hold_Port
setfreq m4
LOW Tx_Data_Port
PAUSE 50 
READADC Sw_Port,ADC_Val
IF Toggle_Port = 0 THEN
	LET Key_Addr = 0
ELSE
	LET Key_Addr = 1
eNDIF
LET Threshold = Start_Count
DO  WHILE Threshold < ADC_Val
	LET Threshold = Threshold + Step_Count
	LET Key_Addr = Key_Addr + 2
LOOP
READ Key_Addr,Key_Code
IF Key_Code < $30 THEN					'This is a Display Code less 64
	LET Display_Code = Key_Code + $40
	LET Key_Code = "O"
ENDIF
HIGH TX_Data_Port						'This pulse unlocks the receiver
PAUSE TX_Preamble
LOW TX_Data_Port
PAUSE TX_Ser_Setup
IF Key_Code = "O" THEN
	SEROUT TX_Data_Port,N2400_4,("14L1776O,",Display_Code)	
ELSE
	SEROUT TX_Data_Port,N2400_4,("14L1776",Key_Code)	
ENDIF
SEROUT TX_Data_Port,N2400_4,(13,10)	            'The CR,LF is for recording
PAUSE 50
LOW Hold_Port
END