#rem	3-button_transmitter.bas This has three large colored buttons
They may be pressed individually or in any combination.
The transmitter sends a lettercode corresponding to the combination.
John Saunders 9/2/2022 Different codes:some with dual transmissions

Count	 First Transmission		Second Transmission
 1	rgb Display Temperature		rgb Display Temperature
 2	rgb Display Humidity		rgb Display Humidity
 3	Hanging Light On			Hanging Light On
 4	rgb Display Garage Fan		rgb Display Garage Fan
 5	Gazebo String On			Eves Icycle String On
 6	Hanging Light Off			Hanging Light Off
 7    Gazebo String Off			Eves Icycle String Off
#endrem
#picaxe 08M2

'Inputs
symbol Blue_Button  = pinC.1		'Weight 4
symbol Green_Button = pinC.3		'Weight 2
symbol Red_Button   = pinC.4  	'Weught 1, inverted

'Outputs
symbol Out_Port = C.0
symbol PWM_Port = C.2

DATA 0,("O","O","I","O","7","C","6")	'First Transmission
DATA 7,("C","D","I","A","m","C","J")	'Second Transmission


'Variables
symbol Press_Val = b1	'0 never happens,1=Red,2=Green,,4=Blue,5=Red+Blue,6=Blue+Green,7=All 3 buttons
symbol Out_Alpha = b2
symbol KeyCode   = b3 
symbol dataAddr  = b4



'Constants
symbol Button_Wait      = 300
symbol TX_Preamble      = 20		'A long pulse before the serial transmission to trigger an interrupt
symbol TX_Ser_Setup     = 10		'Gives time to execute the SERIN command in the interrupt procedure
symbol TxPause		= 500

main:
SETFREQ m4
PWMOUT PWM_Port,100,200 
PAUSE Button_Wait
LET Press_Val = 2*Green_Button + Red_Button
LET Press_Val = 4*Blue_Button + Press_Val
LET dataAddr = Press_Val - 1
READ dataAddr,KeyCode
IF KeyCode = "O" THEN		'A display commend
	LET Out_Alpha = "O"
	LET dataAddr = Press_Val + 6
	READ dataAddr,KeyCode
	GOSUB transmit
	PAUSE TxPause
	GOSUB transmit
ELSE
	LET Out_Alpha = " "
	GOSUB transmit
	PAUSE TxPause
	LET dataAddr = Press_Val + 6
	READ dataAddr,KeyCode
	GOSUB transmit
ENDIF
PWMOUT PWM_Port,OFF
END

transmit:
HIGH Out_Port			'This pulse unlocks the receiver by an interrupt via an integrator
PAUSE TX_Preamble
LOW Out_Port
PAUSE TX_Ser_Setup
SEROUT Out_Port,N2400_4,("14L1776") 'This preamble locks out other transmissions
IF Out_Alpha = "O" THEN
	SEROUT Out_Port,N2400_4,("O",",")
ENDIF
SEROUT Out_Port,N2400_4,(KeyCode,13,10)
RETURN
