#rem 8-pos-transmitter.bas
7/18/2024
#endrem
#PICAXE 08M2

'Ports
symbol TX_Data_Port     = C.0		'Idle low serial transmission at 2400 baud
symbol Sw_2             = pinC.1	'Switch BCD bit 2
symbol Sw_1             = pinC.3    'Switch BCD bit 1
symbol Sw_0             = pinC.4    'Switch BCD bit 1  
symbol PWM_Port         = C.2		'Keeps the power flowing, charges the gate with a 10 KHz square wave

'Variables
symbol TX_Value         = b1		'The value of the code for switch position
symbol Repeat_Index	= b2		'For loop counter
symbol Tx_Char		= b3		'Character to be transmitted
symbol Tx_Flag		= b4		; O or N
symbol Data_Index		= b5

'Constants
symbol TX_Interval	= 500  	'Time between transmissions
symbol TX_Times		= 2		'The number of transmissions before shutoff
symbol TX_Preamble      = 20		'A long pulse before the serial transmission to trigger an interrupt
symbol TX_Ser_Setup     = 10		'Gives time to execute the serial in command in the interrupt procedure

'Transmitted character
'        OFF   ON
DATA 0,("c","a")		'Flower 	Value 0,1
DATA 2,("k","i")		'Pole		Value 2,3
DATA 4,("m","l")		'Tower, precede with "O"Value 4.5
DATA 6,("G","Q")		'Gate include wth siren	Value 6,7
DATA 8,("H","h")		'Siren			Value 6,7



Init:
SETFREQ m4
PWMOUT  PWM_Port,100,200		'Time to start up = 30 ms, freq = 10 KHz 
Tx_Flag = "N"

main:
LET TX_Value = 2*Sw_1 + Sw_0
LET TX_Value = 4*Sw_2 + TX_Value
SELECT TX_Value
	CASE 0 TO 3
		Tx_Flag = "N"
	CASE 4,5
		Tx_Flag = "O"
	CASE 6,7
		Tx_Flag = "T"
		
ENDSELECT
Data_Index = Tx_Value
READ Data_Index,Tx_Char
FOR Repeat_Index = 1 TO TX_Times
	GOSUB transmit	
NEXT
IF Tx_Flag = "T" THEN
	Data_Index = TX_Value + 2
	READ Data_Index,Tx_Char
	FOR Repeat_Index = 1 TO TX_Times
		GOSUB transmit	
	NEXT	
ENDIF
PWMOUT PWM_Port,OFF
PAUSE 300
END

transmit:
HIGH TX_Data_Port			'This pulse unlocks the receiver
PAUSE TX_Preamble
LOW TX_Data_Port
PAUSE TX_Ser_Setup
IF Tx_Flag = "O" THEN
	SEROUT TX_Data_Port,N2400_4,("14L1776O,",Tx_Char,13,10)		'The CR,LF is for debugging
ELSE
	SEROUT TX_Data_Port,N2400_4,("14L1776",Tx_Char,13,10)
ENDIF
PAUSE TX_Interval
RETURN