#rem 6Button-transmitter.bas
John Saunders  9/2/2022 checked 7/21/2024
#endrem
#PICAXE 14M2

'Output Ports
symbol TX_Data_Port     = B.0		'Idle low serial transmission at 2400 baud
symbol Power_Port   	= B.3		'Turns on the power using PWM
symbol Sound_Port		= B.4		'Makes a beep

'Input Ports, go to 0 on press
symbol Red_Button		= PinC.1	'Weight 1  Pin 3 "R"
symbol Green_Button	= PinC.2	'Weight 2  Pin 5 "G"
symbol Blue_Button	= PinC.4	'Weight 4  Pin 6 "B"
symbol Yellow_Button	= PinC.3	'Weight 8  Pin 4 "Y"
symbol White_Button	= PinC.0	'Weight 16 Pin 2 "W"
symbol Black_Button	= PinB.5	'Weight 32 Pin 1 "K"

'Variables
symbol scratch		= b1
symbol dataAddr 		= b2
symbol pressVal		= b3		'EEPROM address for the control character to be transmitted
symbol Index		= b4		'For loop counter
symbol Char			= b5		'Character to be transmitted
symbol Out_Alpha 		= b6

'Constants
symbol TX_Interval	= 500  	'Time between transmissions
symbol TX_Preamble      = 20		'A long pulse before the serial transmission to trigger an interrupt
symbol TX_Ser_Setup     = 10		'Gives time to execute the serial in command in the interrupt procedure
symbol Button_Wait      = 400		'Helps to perform double presses
symbol DisplayStartAddr = 20
symbol CommandStartAddr = 40
symbol TxPause		= 500

'EEPROM
DATA 0,("O","O","I","O","7","C","6")	'First Transmission
DATA 7,("C","D","I","A","m","C","J")	'Second Transmission
DATA DisplayStartAddr,(103,100,102,101,99,69,66)
DATA CommandStartAddr,(71,82,89,87,103,77,57,100,56,75,107,105,102,98,85,83)



Init:
SETFREQ m4					'To conserve power
HIGH Power_Port
PWMOUT PWMDIV4,Sound_Port,63,126
LOW TX_Data_Port
PAUSE Button_Wait
LET pressVal = 2*Green_Button  + Red_Button
LET pressVal = 4*Blue_Button    + pressVal
LET pressVal = 8*Yellow_Button + pressVal
LET pressVal = 16*White_Button + pressVal
LET pressVal = 32*Black_Button  + pressVal


IF pressVal < 8 THEN		'A 3-button compatible commend
	LET dataAddr = PressVal - 1
	READ dataAddr,scratch
	IF scratch = "O" THEN		'A display commend	
		LET Out_Alpha = "O"
		LET dataAddr = PressVal + 6
		READ dataAddr,char
		GOSUB transmit
	ELSE
		LET Out_Alpha = " "
		LET Char = scratch
		GOSUB transmit
		PAUSE TxPause
		LET dataAddr = PressVal + 6
		READ dataAddr,Char
		GOSUB transmit
	ENDIF
ELSE
	LET Index = 100
	LOOKDOWN pressVal,(36,12,41,34,33,20,52),Index
	IF Index < 100 THEN
		LET Out_Alpha = "O"
		LET dataAddr = DisplayStartAddr + Index
		READ dataAddr,Char
		GOSUB transmit
	ENDIF
	LOOKDOWN pressVal,(48,14,11,42,19,38,32,16,9,8,40,10,49,17,22,21),Index
	IF Index < 100 THEN
		LET Out_Alpha = " "
		LET dataAddr = CommandStartAddr + Index
		READ dataAddr,Char
		GOSUB transmit
	ENDIF
ENDIF
PWMOUT Sound_Port,OFF
LOW Power_Port
PAUSE 1000
END

transmit:
HIGH TX_Data_Port			'This pulse unlocks the receiver by an interrupt via an integrator
PAUSE TX_Preamble
LOW TX_Data_Port
PAUSE TX_Ser_Setup
SEROUT TX_Data_Port,N2400_4,("14L1776") 'This preamble locks out other transmissions
IF Out_Alpha = "O" THEN
	SEROUT TX_Data_Port,N2400_4,("O",",")
ENDIF
SEROUT TX_Data_Port,N2400_4,(Char,13,10)
RETURN
