#rem
Rotary 7-pos toggle.bas This is for the little wooden box with the 7-position rotary switch
and 2-way momentary toggle. It is labelled for and controls the living room lights:
Pos 	On Off		Codes transmitted
1 	I   C (Hanging) The macrame lamp hanging from the ceiling, .
2 	R   G (Ceiling) ceiling Light 
3 	7   6 (String) The LED string hanging from the gazebo
4 	m   J (Icycle) The LED string hanging from the eves
5 	d   9 (Eggs) The leads from the "Octupus" 60 MA series from the current regulator
6 	Y   W (Flashing) The bases with individual transformers 
7 	M   g (Missions) The model missions.
John Saunders 10/31/2016
#endrem

#picaxe 08M2

'Inputs:
symbol TX_Data_Port     = C.0		'Idle low serial transmission at 2400 baud
symbol On_Off_Port      = pinC.2	'Low for ON (up)
symbol Rot_Sw_Port      = C.4		'An analog value giving the position of the rotary switch

'Output
symbol Hold_Port        = C.1		'A high maintains power to the circuits.

'Constants
symbol Start_Count      = 22		'Half way to the count for the Floor position
symbol Step_Count       = 42		'Count between switch positions
symbol TX_Preamble      = 20		'A long pulse before the serial transmission to trigger an interrupt
symbol TX_Ser_Setup     = 10		'Gives time to execute the serial in command in the interrupt procedure

'EEPROM
'DATA 0,("I","C","b","f","K","8","Y","W","E","F","P","W","M","W")
'DATA  0,("I","C","R","G","K","8","Y","W","E","F","P","W","M","W")  
DATA  0,("I","C","R","G","7","6","m","J","d","9","Y","W","M","g")
'Variables
symbol Sw_Pos           = b1		'0-13, even = on, order = Hanging,Floor,Icicle,Top,Shelf,Circle,Bullseye
symbol Rot_Sw_Val		= b2		'Analog measurement
symbol Threshold        = b3		'The value to compare the analog to
symbol Char             = b4
symbol Mom_Sw_Pos       = b5		'0 for ON

init:
HIGH Hold_Port
SETFREQ m4

main:
LET Mom_Sw_Pos = On_Off_Port
READADC Rot_Sw_Port,Rot_Sw_Val
FOR Sw_Pos = 0 TO 5
	LET Threshold = Sw_Pos * Step_Count + Start_Count
	IF Rot_Sw_Val <  Threshold THEN 
		EXIT
	ENDIF
NEXT Sw_Pos
IF Rot_Sw_Val >  Threshold THEN
	LET Sw_Pos = 6
ENDIF
LET Sw_Pos = 2*Sw_Pos + Mom_Sw_Pos
READ Sw_Pos, Char
HIGH TX_Data_Port			'This pulse unlocks the receiver
PAUSE TX_Preamble
LOW TX_Data_Port
PAUSE TX_Ser_Setup
SEROUT TX_Data_Port,N2400_4,("14L1776",Char,13,10)		'The CR,LF is for debugging
LOW Hold_Port
PAUSE 5000
GOTO main




