#rem
Transparent.bas An acrylic  box. 
The 7-position rotary switch is connected to taps on an 8-resistor divider resistor potentiometer.
The voltage is measured and combined with the toggle position and a slide switch to provide 28 indices.
These point to command codes. However certain commands have a 2-character code, the first being O.
These have 128 added to them as a marker.
For the names associated with the key and display codes see Selector.xls.
John Saunders 6/10/2020. 1/19/2021 substitute clear outside outlet for girl fountain
#endrem

#picaxe 08M2

rem Inputs
symbol TX_Data_Port     =C.0		'Idle low serial transmission at 2400 baud 
symbol Selector_Port	= C.2
symbol Toggle_Port      = PinC.4
symbol Slide_Port        = PinC.3

rem Outputs
symbol Hold_Port		= C.1

rem Constants
symbol TX_Preamble	= 20		'A long pulse before the serial transmission to trigger an interrupt
symbol TX_Ser_Setup	= 10		'Gives time to execute the serial in command in the interrupt procedure
symbol Start_Count	= 16
symbol Step_Count		= 32

rem Variables
symbol ADC_Val		= b1
symbol Key_Addr		= b2
symbol Threshold		= b3
symbol Key_Code		= b4
symbol Display_Code     = b5
symbol Slide_Val =  b6
symbol Toggle_val = b7

rem Key Code list
rem           0   1    2     3    4   5   6   7    8    9   10  11   12 13
DATA	0,    (193,194, 195,  196 ,197,198,"b","f", "d", "9" ,"P","l","M","g")
rem           14    15   16  17  18  19  20  21  22  23  24  25  26   27
DATA 14,    ( "3" , "2" ,"1","0","7","6","5","4","R","G","m","J","I","C")
rem DATA 14,( "3" , "2" ,"1","0","7","6","5","4","R","G","J","T","I","C")

main:
HIGH Hold_Port
setfreq m4
LOW Tx_Data_Port
PAUSE 50 
LET Toggle_Val = Toggle_Port
LET Slide_Val = 14 *  Slide_Port
READADC Selector_Port,ADC_Val
LET Threshold = Start_Count
LET  Key_Addr = 14
DO  WHILE Threshold < ADC_Val
	LET Threshold = Threshold + Step_Count
	LET Key_Addr = Key_Addr - 2
LOOP
LET  Key_Addr = Key_Addr + Slide_Val + Toggle_Val
READ Key_Addr,Key_Code
IF Key_Code > 128 THEN					'This is a Display Code less 128
	LET Display_Code = Key_Code  -128
	LET Key_Code = "O"
ENDIF
HIGH TX_Data_Port						'This pulse unlocks the receiver
PAUSE TX_Preamble
LOW TX_Data_Port
PAUSE TX_Ser_Setup
IF Key_Code = "O" THEN
	SEROUT TX_Data_Port,N2400_4,("14L1776O,",Display_Code)	
ELSE
	SEROUT TX_Data_Port,N2400_4,("14L1776",Key_Code)	
ENDIF
SEROUT TX_Data_Port,N2400_4,(13,10)	            'The CR,LF is for recording
PAUSE 50
LOW Hold_Port
END