#rem Line_Monitor.bas  This is for the double blue outlet box 
with attached black enclosure with a DB-9 S for the Universal Transmitter
It measures line voltage from 60 to 150 V with a precision of 100 mv
It measures the currenr of the load on either duplex outlet 0-5A with precision 5 MA
John Saunders 10/14/2021  Changed key Code from u to n
#endrem

#picaxe 08M2
rem inputs
symbol VoltPort		= C.4
symbol AmpPort		= C.2
rem Outputs dir - 'm';
symbol TxOut		= C.0
rem variables
symbol scratch		= b1
symbol iter			= b2
symbol LoopCount	= b3
symbol Char			= b12
symbol Hunds		= b5
symbol Units		= b6
symbol Tens			= b7
symbol Thous		= b8
symbol Chcksum		= b10
symbol ChckHex		= b11
symbol AmpDiff		= w10
symbol OldAmps		= w11
symbol DecData		= w12
symbol Amps			= w13

rem constants
symbol VoltOffset	= 494
symbol AmpCorr		= 20
symbol AmpDelta		= 100	

init:
LET LoopCount = 0
LET OldAmps = 0
SETFREQ m4

main:
READADC10 VoltPort,DecData
LET DecData = DecData + VoltOffset
'SERTXD (#DecData,"V,")
LET bptr = 28
GOSUB StoreDec
LET DecData = 0
FOR Iter = 0 TO 4
	READADC10 AmpPort,Amps
	LET DecData = DecData + Amps
	PAUSE 9
NEXT
LET DecData = DecData - AmpCorr
'SERTXD (#DecData,"A",13,10)
LET bptr = 28 + 5
GOSUB StoreDec
IF DecData > OldAmps THEN
	LET AmpDiff = DecData - OldAmps
ELSE
	LET AmpDiff = OldAmps - DecData 
ENDIF
IF AmpDiff > AmpDelta THEN
	GOSUB Transmit
ENDIF
LET OldAmps = DecData
INC LoopCount
IF LoopCount > 180 THEN
		GOSUB Transmit
ENDIF
IF OldAmps = 0 THEN
	PAUSE 1000
ELSE
	PAUSE 300
ENDIF
GOTO main

StoreDec:
BINTOASCII DecData,Scratch,Thous,Hunds,Tens,Units
POKE bptr,Thous
INC bptr
POKE bptr,Hunds
INC bptr
POKE bptr,Tens
INC bptr
POKE bptr,Units
INC bptr 
POKE bptr,","
RETURN


Transmit:
LET ChckSum = 0				
FOR bptr = 28 TO 36
	PEEK bptr,char
	LET ChckSum = ChckSum + char
NEXT
LET ChckHex = ChckSum / 16
IF ChckHex < 10 THEN
	LET ChckHex = ChckHex + "0"
ELSE
	LET ChckHex = ChckHex + "7"
ENDIF
LET Tens = ChckHex
LET ChckHex = ChckSum & $F
IF ChckHex < 10 THEN
	LET ChckHex = ChckHex + "0"
ELSE
	LET ChckHex = ChckHex + "7"
ENDIF
LET bptr = 28
HIGH TxOut
PAUSE 40
LOW TxOut
PAUSE 20
rem 'E is length code = 60 + length between commas
SEROUT TxOut,N2400_4,("14L1776v,E,",@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptr,Tens,ChckHex,13,10)
LET LoopCount = 0
RETURN