#rem SolarTransmitter.bas 
This is housed in a box for external use. A 5-cell rechargable battery is charged by a olar panel.
Battery voltage, charging current, temperature and humidity are measured.
Temperature and humidity are measured by a Sensirion SHT15 digital module.
The measurements are transmitted on 434 MHz using a Wenshing TWS-BS module
John Saunders 3/13/2017 added checksum;new humidity calculation.10/8/2018 output padded
#endrem
#picaxe 18X

rem Inputs
symbol	SHTIn     = pin6
symbol	I_In      = 1
symbol	V_In      = 0

rem Outputs
symbol	SHTCLK    = 6
symbol	SHTOut    = 7
symbol	TxOut     = 5
symbol	Monitor   = 0

rem Global variables
symbol	SHTACK    = bit0	'0=the SHT accepted the command
symbol	SHTVal    = bit1	'State of the output bit from the SHT
symbol	MeasID    = b1	'What to measure: 0=humidity, 1=temperature,2-current,3=voltage
symbol	Phase     = b2	'The main loop is divided into 10 phases
symbol	Err_Cnt   = bit2

rem General variables
symbol	InByte    = b3
symbol	VarAddr   = b4
symbol	Hunds     = b5
symbol	Units     = b6
symbol	Tens      = b7
symbol	Mask      = b8
symbol	Char      = b9

symbol	InWord    = w6
symbol	Scratch   = w5


rem EEPROM
DATA 0,(128,64,32,16,8,4,2,1)	
DATA 10,( 0, 0, 1, 1, 2, 4, 5, 6, 7, 8)	
DATA 20,( 9,10,11,12,14,15,16,17,18,19)	
DATA 30,(20,21,22,23,24,25,26,28,29,30)	
DATA 40,(31,32,33,34,35,36,37,38,30,40)	
DATA 50,(41,42,43,44,45,46,47,48,49,50)	
DATA 60,(51,52,53,54,55,56,57,58,59,60)	
DATA 70,(61,62,63,64,64,65,66,67,68,69)	
DATA 80,(70,71,72,73,74,75,76,76,77,78)	
DATA 90,(79,80,81,82,83,84,84,85,86,87)	
DATA 100,(88,89,90,90,91,92,93,94,95,96)	
DATA 110,(96,97,98,99,100)	

rem Constants
symbol	Pulseval  = 20
symbol 	SHTPeriod = 5400
symbol	SHTGap    = 560
symbol	StartAddr = 80
symbol	MinOKVolt = 140 

init:
SETFREQ m8
LOW SHTCLK
LOW TxOut
LOW SHTOut
LET Phase = 0
SLEEP 1
FOR Char = 0 TO 9
	PULSOUT SHTClK,Pulseval
NEXT Char
LET Err_Cnt = 0
LOW Monitor

main:
LOOKUP Phase,(3,2,0,2,3,2,1,2,3,2,3,3,2,0,2,3,2,1,2,3,2,3),MeasID
LET VarAddr = 2 * MeasID + StartAddr
SELECT MeasID
	CASE 0,1		'SHT
		GOSUB	SHTCommand
		IF SHTACK = 0 THEN
			GOSUB SHTWait
			GOSUB SHTMeas
			LET char = VarAddr + 1
			POKE char,InByte
			HIGH SHTOut
			PULSOUT SHTCLK,Pulseval
			GOSUB SHTMeas
			POKE VarAddr,InByte
		ELSE
			LET Err_Cnt = 1
		ENDIF
	CASE 2		'Solar charging current
		READADC I_in,InByte
		LET InByte = 256 - InByte
		PEEK VarAddr,WORD InWord
		LET InWord = InWord + InByte
		POKE VarAddr,WORD InWord
	CASE 3
		READADC V_In,InByte
		IF InByte < MinOKVolt THEN init	'Out of regulation
		PEEK VarAddr,WORD InWord
		LET InWord = InWord + InByte
		POKE VarAddr,WORD InWord
	ELSE	
		LET InWord = 0
ENDSELECT
PAUSE SHTPeriod
INC Phase
IF Phase > 21 THEN
	LET Phase = 0
	GOSUB WriteOut
	FOR Char = 4 TO 7					;Current and voltage
		LET VarAddr = StartAddr + Char
		POKE VarAddr,0
	NEXT
	IF Err_Cnt = 1 THEN init
ENDIF
GOTO main

SHTCommand:	'SHTCmd is 1 for Humidity, 0 for temperature
rem SHT Start:
HIGH SHTCLK
HIGH SHTOut
LOW SHTCLK
HIGH SHTCLK
LOW SHTOut
LOW SHTCLK
HIGH SHTOut
PAUSE 1
rem SHT Command
IF MeasID = 1 THEN 
	LET Scratch = 5	'Humidity
ELSE
	LET Scratch = 3	'Temperature
ENDIF
FOR Char = 0 TO 7
	READ Char,Mask 
	LET InByte = Scratch & Mask
	IF Inbyte = 0 THEN
		HIGH SHTOut
	ELSE
		LOW SHTOut
	ENDIF
	PULSOUT SHTCLK,Pulseval
NEXT Char
LET SHTACK = SHTIn		'If 0 ack is OK
PULSOUT SHTCLK, Pulseval
LOW SHTOut
RETURN

SHTMeas:
LET InByte = 0
LOW SHTCLK
LOW SHTOut
FOR Char = 0 TO 7
	READ Char,Mask
	LET SHTVal = SHTIn 
	IF SHTVal = 1 THEN
		LET InByte = InByte + Mask
	ENDIF
	PULSOUT SHTCLK,Pulseval
NEXT Char
RETURN

WriteOut: 					'216 ms
LET Char = 132				'3 commas
HIGH TxOut
PAUSE 40
LOW TxOut
PAUSE 20
SEROUT TxOut,N2400_8,("14L1776s,K,")	'K is code for 15
FOR MeasID = 0 TO 3
	LET Mask = 2 * MeasID + StartAddr
	PEEK Mask, WORD InWord
	IF MeasID = 0 THEN		'Temperature
		IF InWord > 0 THEN
			LET InWord = InWord/10
			LET InWord = 9 * InWord
			LET InWord = InWord - 1978
			LET Scratch = InWord/50
		ELSE
			LET Scratch = 32
		ENDIF
	ENDIF
	IF MeasID = 1 THEN		'Humidity
		LET VarAddr = InWord/31 + 10
		IF VarAddr > 114 THEN
			LET Scratch = 100
		ELSE
			READ VarAddr,Scratch
		ENDIF
	ENDIF
	IF MeasID = 2 THEN  	'Current
		LET Scratch = InWord/20
	ENDIF
	IF MeasID = 3 THEN  	'Battery Voltage
		LET Scratch = InWord/2
	ENDIF
	LET Hunds = Scratch/100 + 48
	LET InByte = Scratch // 100
	LET Tens = InByte /10 + "0"
	LET Units = InByte // 10 + 48
	LET Char = Char + Hunds + Tens + Units
	SEROUT TxOut,N2400_8,(Hunds,Tens,Units,",")
	'SERTXD (Hunds,Tens,Units,",")
NEXT
LET InByte = Char / 16
IF InByte < 10 THEN
	LET Tens = InByte + "0"
ELSE
	LET Tens = InByte + "7"
ENDIF
LET InByte = Char & $0F
IF InByte < 10 THEN
	LET Units = InByte + "0"
ELSE
	LET Units = InByte + "7"
ENDIF
'SEROUT TxOut,N2400_8,(Tens,Units,13,10)
SEROUT TxOut,N2400_8,(Tens,Units,13,10,4,4,4,4,4,4)	'Padding added 10/8/2018
'SERTXD (Tens,Units,13,10,4,4,4,4,4,4)
RETURN

SHTWait:				'68 & 244 ms
LET Char = 0
DO
	INC Char
	LET SHTACK = SHTIn		'If 0 measurement is done
	PAUSE 1
LOOP WHILE Char < SHTGap AND SHTACK = 1
RETURN 
