rem Transparent-Flip-top-Box-Receiver.bas  John Saunders 11/20/2022
#picaxe14M2

symbol IntPort      = pinC.0
symbol ReceiverData = C.3
symbol TransmitData = C.1
' symbol TransmitData = B.0
symbol RTS          = C.4
symbol BlueLED      = B.1

symbol IntScratch = b1
symbol KeyCode    = b2
symbol RcvrCnt    = b3
symbol FlagID     = b4
symbol MsgLen     = b5
symbol ChckSum    = b6
symbol ChckHex    = b7
symbol FlagData   = b8
symbol IntCode0   = b9
symbol IntCode1   = b10
symbol RcvrHex    = b11


symbol rcvrStartAddr = 31

Init:
SETFREQ m8
SETINT  %00000001,%00000001	'Interrupt when C,0 high

main:
PAUSE 100
LET b0 = 0xcf
LET bit0 = pinB.2
LET bit1 = pinB.3
LET bit2 = pinB.4
LET bit3 = pinB.5
LET b0   = NOT B0

GOTO main

Interrupt:
LET bptr = rcvrStartAddr
POKE 	rcvrStartAddr, " "		' For command/Display	
LET KeyCode = 138
LET MsgLen = 0				' Eliminates some spurious minterrupts
LET FlagID = " "
LET IntScratch = 0
DO WHILE IntPort = 1 
	LET IntScratch = IntScratch + 1
LOOP 		'There is a 10 ms gap before the code to allow the serin to execute
IF IntScratch < 10 OR IntScratch > 200 THEN NotMine 
LET IntScratch = 0
SERIN [60],ReceiverData,N2400_8,("14L1776"),KeyCode,IntCode0,MsgLen,IntCode1,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc
IF KeyCode < "0" OR KeyCode > "z" THEN NotMine
IF KeyCode = "O"  AND IntCode0 = "," THEN	
	LET KeyCode = "o"
	LET bptr = rcvrStartAddr
	LET @bptrinc = "D"
	LET @bptrinc = ","
	LET @bptr = MsgLen
	LET RcvrCnt = 3
	GOTO storeInt
ELSEIF  KeyCode < "n" THEN
	LET bptr = rcvrStartAddr 
	LET IntScratch = KeyCode	
	LET KeyCode = "o"
	LET @bptrinc = "C"
	LET @bptrinc = ","
	LET @bptr = IntScratch
	LET RcvrCnt = 3
	GOTO storeInt
ENDIF
IF KeyCode >= "n" AND KeyCode <= "z" THEN
	IF MsgLen < 61 OR MsgLen > 81 THEN NotMine
	LET RcvrCnt = MsgLen - 61		'Address of last message byte
	LET ChckSum = 0
	LET bptr = rcvrStartAddr		
	FOR IntScratch = 0 TO RcvrCnt
		LET   ChckSum = ChckSum + @bptrinc
	NEXT
	LET ChckHex = ChckSum / 16
	IF ChckHex < 10 THEN
		LET ChckHex = ChckHex+ "0"
	ELSE
		LET ChckHex = ChckHex + "7"
	ENDIF
	LET bptr = bptr + 1
	LET RcvrHex = @bptrinc
	IF ChckHex <> RcvrHex THEN
		LET FlagID = "E"
		LET FlagData = KeyCode 
		GOTO NotMine
	ENDIF
	LET ChckHex = ChckSum & $F
	IF ChckHex < 10 THEN
		LET ChckHex = ChckHex + "0"
	ELSE
		LET ChckHex = ChckHex + "7"
	ENDIF
	LET RcvrHex = @bptrinc
	IF ChckHex <> RcvrHex THEN
		LET FlagID = "F"
		LET FlagData = KeyCode 
		GOTO NotMine
	ENDIF
ENDIF
storeInt:
HIGH RTS
HIGH BlueLED
'SERTXD ("<",KeyCode,",")
SEROUT TransmitData, T9600_8,("<",KeyCode,",")
LET bptr = rcvrStartAddr
FOR IntScratch = 0 TO RcvrCnt
'	SERTXD (@bptrinc)
 	SEROUT TransmitData,T9600_8,(@bptrinc)
NEXT
IF KeyCode = "s" THEN
' SERTXD (b0)		
SEROUT TransmitData, T9600_8,(b0)
' SERTXD (">",13,10)
ENDIF		
SEROUT TransmitData, T9600_8,(">",13,10)
LOW RTS
PAUSE 100
LOW BlueLED
GOTO noError
NotMine:
SERTXD ("Error:",FlagID,",",FlagData,13,10)
noError:
SETINT  %00000001,%00000001	'Interrupt when C,0 high
RETURN