#rem Alarm_Receiver2024.BAS  This is for the wood cube with the speaker
The Receiver gets a 433 Mhz signal from the gate transmitter or the 6-button Transmitter
The main loop of 1/10 sec times LED on duration, blinking and flashing
The command codes accepted are in KeyVal and have correspondinf OpCodes as inteces to the parameter tables in EEPROM:
e:0 Flashes blue LED battery volts in morse code
D:1 Flashes green LED battery tenth volts in morse code 
A;2 Lights red LED
H:3 Turns off the LEDs
Q:4 Lights red LED and plays Gate Open tun
B:5 Lights red LED and plays Gate Closed tune
h:6 Flashes red LED and plays Siren tune
John Saunders 11/13/2024
#endrem

#PICAXE 14M2

'Input Ports
symbol RcvrPort     = B.1		'Idle low
symbol Batt_Mon     = B.2		'1/2 of the battery voltage
symbol Chg_Mon      = B.3		'1/4 of the charging voltage
symbol Reg_Err      = pinC.3		'Goes low if the 5V regulator drops below 5V

'Output Ports
symbol Outport	  = B.0
symbol Aud_Cont     = B.4
symbol Aud_Tune     = B.5
symbol Red_LED      = C.1
symbol Green_LED    = C.2
symbol Blue_LED     = C.4
    
'Variables 
'Interrupt variables
symbol Temp         = b1		
symbol KeyVal       = b2
symbol LF_Val       = b3
symbol CR_Val       = b4

'Specific variables
symbol MorseStep		= b10
symbol Loop_Cnt    	= b11		'Count of main loop of 1/10 sec		=  7
symbol DataAddr		= b12
symbol OpCode		= b14		'Index into parameter tables
symbol Steplen		= b15
symbol DigitVal		= b16
symbol DecVal		= b17
symbol Batt_Mv		= w10		'ADC output
symbol PauseVal		= w11

'General variables
symbol Scratch      	= b4


'Constants
symbol MorseInterval	= 50
symbol MaxOpCode		= 7

rem EEPROM tables: 
rem morse code for 0-9
DATA   0,(60,60,60,60,60)
DATA   5,(20,60,60,60,60)
DATA  10,(20,20,60,60,60)
DATA  15,(20,20,20,60,60)
DATA  20,(20,20,20,20,60)
DATA  25,(20,20,20,20,20)
DATA  30,(60,20,20,20,20)
DATA  35,(60,60,20,20,20)
DATA  40,(60,60,60,20,20)
DATA  45,(60,60,60,60,20)


Init:
SETFREQ m8
LOW Aud_Cont
LOW Aud_Tune
LOW Outport
LET OpCode = 2
LET Loop_Cnt  = 3		'Count of main loop of 1/10 sec		=  7

SETINT %00000001,%00000001	'Interrupt when RcvrPortt high

Main:
PAUSE 1
LET Loop_Cnt = 3		'Count of main loop of 1/10 sec		=  7
IF OpCode < 2 THEN
	FVRSETUP FVR4096			'1000 count at battery 8V
	ADCCONFIG $03			'Use fixed internal reference
	READADC10 Batt_Mon,Batt_mv	'Battery tap 1/2, scale is 8 mv/count
	LET DigitVal = Batt_mv / 125SERTXD ("Op Code = ",#OpCode,13,10)
	LET DecVal = Batt_mv // 125
	LET DecVal = 2 * DecVal
	LET DecVal = DecVal/25
	SERTXD (#Batt_mv,": ", #DigitVal,".",#DecVal,13,10)
	SETINT OFF
	FOR MorseStep = 0 TO 4
		IF OpCode = 0 THEN
			LOW Blue_LED
			LET DataAddr = 5 * DigitVal + MorseStep 
		ELSE
			LET DataAddr = 5 * DecVal + MorseStep 
			LOW Green_LED
		ENDIF
		READ DataAddr,StepLen 
		FOR Scratch = 0 TO StepLen
			PAUSE MorseInterval
		NEXT
		HIGH Blue_LED
		HIGH Green_LED
		FOR Scratch = 0 TO 50
			PAUSE MorseInterval
		NEXT
	NEXT
	LET OpCode = 2
	SETINT %00000001,%00000001	'Interrupt when RcvrPortt high
ENDIF
IF OpCode >2 AND OpCode < MaxOpCode THEN
	SERTXD ("Op Code = ",#OpCode,13,10)
	LOW Red_LED
	HIGH Aud_Cont
	PAUSE 250		'Time for the audio amp to stabilize
	SETINT OFF
	SELECT OpCode
	CASE 3		'Short Tune
		TUNE Aud_tune,5,($40,$05,$49,$05,$40,$2BC7,$45,$04,$47,$04,$64,$29,$C5,$40,$05,$49,$05,$40,$2B,$C7,$45,$04) 
	CASE 4		'Chime
		TUNE Aud_tune,2,($04,$07,$05,$AB) 
	CASE 5		'Baba
		TUNE Aud_tune,2,($30,$30,$37,$37,$79,$7B,$40,$79,$37,$3C,$35,$35,$34,$34,$32,$32,$30)
	CASE 6		'Siren
		'SETINT %00000001,%00000001
		FOR Scratch = 0 TO 20
		 'SOUND Aud_Tune,(86,300,95,300,86,300,95,300,86,300,95,300,86,300,95,300,86,300,95,300,86,300,95,300,86,300,95,300)
		SOUND Aud_Tune,(86,300,95,300)
	'	PAUSE 30
	'	IF OpCode = 2 THEN EXIT
		NEXT
	ELSE
		LOW Aud_Cont	
	ENDSELECT
	LET OpCode = 2
	LOW Aud_Cont
	SETINT %00000001,%00000001	'Interrupt when RcvrPortt high	
ENDIF
LET PauseVal = Loop_Cnt * 124
PAUSE PauseVal
HIGH Red_LED	
HIGH Blue_LED
HIGH Green_LED
GOTO Main


Interrupt:
LET KeyVal = "z"
LET LF_Val  = 0
LET CR_Val  = 1
LET temp = 0
LET OpCode = MaxOpCode				'6/24/2024	
DO WHILE PinC.0 = 1
	LET temp = temp + 1	'Twice as fast as INC Usual count is 15
LOOP
IF temp < 5 OR temp > 20 THEN 
	GOTO End_Interrupt	'Minimises the time to recover from a noise interrupt
ENDIF
SERIN [40],RcvrPort,N2400_8,("14L1776"),KeyVal,CR_Val,LF_Val,temp,temp,temp
'SERTXD ("Key Code = ",KeyVal, ",CR = ", #CR_Val, ",LF = ",#LF_Val,13,10)
IF KeyVal = "O" OR KeyVal >= "n" THEN End_Interrupt
IF LF_Val <> 10 OR CR_Val <> 13 THEN End_Interrupt
LOOKDOWN KeyVal,("e","D","H","A","Q","B","h"),OpCode
End_Interrupt:
SETINT %00000001,%00000001	'Interrupt when RcvrPortt high
RETURN