#rem  Flower_Monitor_Receiver_Chcksum.bas This is the receiver decorated with flowers
It has options for both source (4V) and sink (open collector) outputs, and a 5V regulator with 7-16V input
Repeats messages received by RF
John Saunders 2/28/2017 Checks the checksum on messages,     4/26/20 better messages
#endrem

#picaxe 08M2

'Output Ports
symbol Out_Port    = C.1		'Controls the low logic output, pim 0
symbol LED_Port    = C.2		'Lights the blue LED and controls the high logic output Pin 8


'Input ports
symbol Rcvr_Port   = C.4
symbol Int_Port    = pinC.3

'Variables
symbol RcvrCnt	 = b1			'The address of the last message byte received
symbol Int_Iter    = b2			'Used only in an interrup
symbol RcvrIn      = b4			'The key code
symbol Pulse_Cnt   = b5
symbol ChckSum	 = b6			'Summation of the bytes in MsgLen
symbol MsgLen	 = b7			'The number of bytes bracketed by commas less 60
symbol ChckHex	 = b8			'Hex from ChkSum
symbol RcvrHex	 = b9			'Hex from message
symbol dispSel		= b10		'After a key "O"

'Constants
symbol DefFile	= "v"			'Log

init:
SETFREQ m8
HIGH LED_Port			'Off
LOW Out_Port
SETINT  %00001000,%00001000	'Interrupt when C,3 high

main:
PAUSE 1
GOTO main

RETURN

Interrupt:
LET bptr = 28		'Max is 127
LET RcvrIn = "Z"
LET Pulse_Cnt = 0
DO WHILE Int_Port = 1
	LET  Pulse_Cnt = Pulse_Cnt + 1
LOOP				'There is a 10 ms gap before the code to allow the serin to execute
IF Pulse_Cnt < 5 OR Pulse_Cnt > 121 THEN NotMine '10 for t & s, 15 for p or r
rem                                                                                 28       29            30           31      32       33       34        35                                            
rem                                                                                  ,      MsgLen         ,          byte1...
SERIN [80],Rcvr_Port,N2400_8,("14L1776"),RcvrIn,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc
IF RcvrIn = "Z" THEN NotMine
LOW LED_Port
SELECT RcvrIn
	CASE "a"
		HIGH Out_Port
		GOTO NotMine
	CASE "c"
		LOW Out_Port
		GOTO NotMine
	CASE "n" TO "z"
		PEEK 29, MsgLen
		IF MsgLen < 61 OR MsgLen > 110  OR Rcvrin = "t" THEN NotMine
		LET RcvrCnt = MsgLen - 30		'Address of last message byte
		LET ChckSum = 0
		FOR Bptr = 31 TO RcvrCnt
			LET   ChckSum = ChckSum + @bptr
		NEXT
		LET ChckHex = ChckSum / 16
		IF ChckHex < 10 THEN
			LET ChckHex = ChckHex+ "0"
		ELSE
			LET ChckHex = ChckHex + "7"
		ENDIF
		LET bptr = RcvrCnt + 2
		LET RcvrHex = @bptrinc
		IF ChckHex <> RcvrHex THEN
			HIGH C.0
			PAUSE 10
			LOW C.0
			PAUSE 10
			SEROUT C.0,N9600_8,("Error1,Key=",RcvrIn,13,10) 
			GOTO NotMine
		ENDIF
		LET ChckHex = ChckSum & $F
		IF ChckHex < 10 THEN
			LET ChckHex = ChckHex + "0"
		ELSE
			LET ChckHex = ChckHex + "7"
		ENDIF
		LET RcvrHex = @bptrinc
		IF ChckHex <> RcvrHex THEN
			HIGH C.0
			PAUSE 10
			LOW C.0
			PAUSE 10
			SEROUT C.0,N9600_8,("Error2,Key=",RcvrIn,13,10) 
			GOTO NotMine
		ENDIF
		POKE 29,Rcvrin
	CASE "O"
		PEEK 29,dispSel
		POKE 29,DefFile,",","P","a","g","e","=",",",dispSel
		LET RcvrCnt = 37
	ELSE
		POKE 29,DefFile,",","C","o","m","m","a","n","d","=",",",Rcvrin
		LET RcvrCnt = 40
ENDSELECT
Transmit:
HIGH C.0
PAUSE 10
LOW C.0
PAUSE 10
FOR bptr = 29 TO RcvrCnt
	SEROUT C.0,N9600_8,(@bptr)
NEXT
SEROUT C.0,N9600_8,(13,10)
NotMine:
HIGH LED_Port
SETINT  %00001000,%00001000	'Interrupt when C,3 high
RETURN