#rem  LR_Receiver.bas This is the receiver in the clear case.
It has four Coax 5.5x2.1 jack outputs 
Use the 12 V power supply
10/30/2016 New off codes 5/24/2021 Added Eggs channel
8/30/2022 Restored normal polarity for C mark and use hanging lamp codes "I", "C"
#endrem

#picaxe 14M2

'Output Ports
symbol Eggs_Jack  	= B.1		'Most ornaments E mark
symbol Flashing_Jack 	= B.2		'Individula turntables F mark
symbol Houses_Jack    	= B.3		'Mission Models H mark
symbol Circle_Jack	= C.2		'Hanging lamp C mark
symbol Green_LED   	= B.4
symbol Red_LED     	= B.5

'Input ports
symbol Rcvr_In     = C.1
symbol Reg_Error   = pinC.3

'Variables
symbol Lamp_on     = bit0
symbol Rcvr_Val     = b1
symbol Sec_Count  = w5


'Constants
symbol Time_out    = 7200


init:
SETFREQ m8
LOW Green_LED
LOW Red_LED
LOW Eggs_Jack
LOW Flashing_Jack
LOW Houses_Jack
LOW Circle_Jack
LET sec_count = 0
LET lamp_on   = 0
SETINT %00000001,%00000001	'Interrupt when C,0 high

main:
Pause 1960
IF Reg_Error = 0 THEN		'Goes low if +5V droops 75 mv 
	LOW Houses_Jack
	LOW Eggs_Jack
	LOW Flashing_Jack
	HIGH Circle_Jack
	HIGH Red_LED
	LET Lamp_on = 0
	LET Sec_Count = 0
ENDIF
IF Lamp_On = 1 THEN
	INC Sec_Count
	IF Sec_Count = Time_out THEN
		LOW Houses_Jack
		LOW Eggs_Jack
		LOW Flashing_Jack
		HIGH Circle_Jack
		HIGH Red_LED
		LET Lamp_on = 0
		LET Sec_Count = 0
	ENDIF
ENDIF     
GOTO main

Interrupt:
'DO WHILE Rcvr_Int = 1	'Interrupt is triggered by a 20 ms burst which exceeds intergator threshold
'LOOP
PAUSE 10				'There is a 10 ms gap before the code to allow the serin to execute
LET Rcvr_Val = "Z"
SERIN [100,NoAscii],Rcvr_In,N2400_8,("14L1776"),Rcvr_Val
SETFREQ m8
IF Rcvr_Val = "Y" THEN			'Individual turntables on
	HIGH Green_LED
	HIGH Flashing_Jack
	LET Lamp_on = 1
ELSEIF Rcvr_Val = "M" THEN		'Missions on
	HIGH Green_LED
	HIGH Houses_Jack	
	LET Lamp_on = 1
ELSEIF Rcvr_Val = "I" THEN		'Hanging Lamp on
	HIGH Green_LED
	HIGH Circle_Jack 
	LET Lamp_on = 1
ELSEIF Rcvr_Val = "d" THEN		'Ornaments on
	HIGH Green_LED
	HIGH Eggs_Jack 
	LET Lamp_on = 1
ELSEIF Rcvr_Val = "W" THEN		'Individual turntables off
	HIGH Green_LED
	LOW Flashing_Jack
	LET Lamp_on = 0
	LET Sec_Count = 0
ELSEIF Rcvr_Val = "g" THEN		'Missions off
	HIGH Green_LED
	LOW Houses_Jack
	LET Lamp_on = 0
	LET Sec_Count = 0
ELSEIF Rcvr_Val = "C" THEN		'Hanging Lamp off
	HIGH Green_LED
	LOW Circle_Jack
	LET Lamp_on = 0
	LET Sec_Count = 0
ELSEIF Rcvr_Val = "9" THEN		'Ornaments off
	HIGH Green_LED
	LOW Eggs_Jack
	LET Lamp_on = 0
	LET Sec_Count = 0			
ELSE
	HIGH Red_LED
	'SERTXD ("Received = ",Rcvr_in,13,10)
ENDIF
PAUSE 300
GOTO End_Interrupt
NoAscii:
HIGH Red_LED
'SERTXD ("Incorrect code",13,10)
PAUSE 300
End_Interrupt:
LOW Red_LED
LOW Green_LED
SETINT %00000001,%00000001	'Interrupt when C.0 high
RETURN