#rem X-10Receiver.bas  2020 version for use with Radio Shack "plug'npower" hacked controller
X10Receiver.bas controls the pole lamp by light messages from the Emvironmental Sensor 
and sends on or off controls every time it gets a solar message.
The pole lamp can also be controlled manually from the 3-button transmitter.
John Saunders 4/19/2020  12/7/2020 Threshold from 4 to 6, add override
4/1/2021 Adaptions needed for extended length of solar message by 2 pad spaces.
1/24/2025 Increrased threshold from 6 to 10 because of neighbor's lamps
3/11/2025 higher threshold on override.
#endrem

#picaxe 08M2

'Outputs
symbol ringPort = C.2
symbol tipPort = C.1

'Inputs
symbol IntPort = pinC.3
symbol MsgPort = C.4

'Variables
symbol Override	  = bit0
symbol Temp		  = b1		
symbol Chcksum 	  = b2
symbol ChckHex  	  = b3
symbol LenCode  	  = b4		'This is used to determine the bytes to include in the checksum
symbol Current      = b5
symbol Rcvr_Val     = b6		'The key code after 14L1776
symbol DuskCount	  = b7             'provides a gradual transition from night to day & vice-versa
symbol Msg_Len      = b8
symbol Threshold	  = b9      	'Equal or above increments DuskCount, less decremenys
symbol Indx		  = b10

'Constants:
symbol DayLight	   = 8	       'maximum value of DuskCount
symbol PulseLength   = 250          'Of the relay. note m8

init:
setfreq m8
LOW ringPort
LOW tipPort
LET Threshold = 10
LET DuskCount = Threshold
LET Override = 0
SETINT %00001000,%00001000	'Re-enable the receiver interrupts again

main:
PAUSE 50
goto main

interrupt:
LET Rcvr_Val = ">"
LET LenCode  = "x"
LET temp = 0		
DO WHILE IntPort = 1
	LET temp = temp + 1	'Twice as fast as INC Usual count is 15
LOOP
IF temp < 10 THEN End_Interrupt	'Minimises the time to recover from a noise interrupt
LET bptr = 28
's message:                            Key Code|comma|LenCode|  comma|      temperature          | comma  |       humidity           | comma  |    solar current         | comma  |     batt volts           | comma  |    padding      |  hex checksum   |  CR    |   LF
SERIN [40],MsgPort,N2400_8,("14L1776"),Rcvr_Val,temp ,LenCode,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptr
SELECT Rcvr_Val
	CASE = "i" 					'Manual ON control overrides
		LET DuskCount = 0
		LET Override = 1
	CASE "k"  				
		LET DuskCount = DayLight
		LET Override = 0
	CASE  "s" 
		IF Rcvr_Val <> "s" THEN End_Interrupt	'Else check solar message
		LET bptr = 28
		LET Chcksum = 0
		LET Current = 0
		LET Msg_Len = LenCode - 32			'Should be "M" = 77 dec
		FOR Indx = 29 TO Msg_Len			'45, end of first pad space
			PEEK Indx, temp
			LET Chcksum = Chcksum + temp
			LET temp = temp - "0"
			SELECT Indx
				CASE 37
					LET Current = 100 * temp 
				CASE 38
					LET Current = 10 * temp + Current
				CASE 39
					LET Current = Current + temp
			ENDSELECT
		NEXT
		LET ChckHex = ChckSum / 16
		IF ChckHex < 10 THEN
			LET ChckHex = ChckHex+ "0"
		ELSE
			LET ChckHex = ChckHex + "7"
		ENDIF
		LET bptr = Msg_Len + 2
		LET temp = @bptr
		INC bptr
		IF ChckHex <> temp THEN End_Interrupt
		LET ChckHex = ChckSum & $F
		IF ChckHex < 10 THEN
			LET ChckHex = ChckHex + "0"
		ELSE
			LET ChckHex = ChckHex + "7"
		ENDIF
		IF ChckHex <> @bptr THEN End_Interrupt
		
		IF Current >= Threshold AND DuskCount < DayLight THEN
			INC DuskCount
		ENDIF
		IF Current < Threshold AND DuskCount > 0 THEN
			DEC DuskCount
		ENDIF
	ELSE
		GOTO End_Interrupt
ENDSELECT
IF DuskCount = 0 OR Override = 1 THEN	'Turn on Pole Lamp
	HIGH RingPort
	LET Threshold = 15
	PAUSE Pulselength
	LOW RingPort
ENDIF
IF DuskCount = DayLight AND Override = 0 THEN  'Turn off Pole Lamp
	HIGH TipPort
	LET Threshold = 10
	PAUSE Pulselength
	LOW TipPort
ENDIF
'sertxd ("Override=",#Override,"Current=",#Current,",DuskCount=",#DuskCount,13,10)
 End_Interrupt:
SETINT %00001000,%00001000	'Re-enable the receiver interrupts again
RETURN