#rem
*******************************
This is for the long LED lamp with attached biege control box.
It turns on using a microwave doppler radar.
It requires to be powered by a 48V power supply with a 5.5x2.1 coax power plug
Maximum current 80 MA
There is an on-off switch on the right.
The left control sets the timeit remains on.
The right control contros the brightness.
; ***** Radar LED Strip *****
; *******************************
;    Filename: RadarLEDStrip		
;    Date: 3/2/2024			
;    File Version:1.0 	
;    Written by: John Saunders			
; ******************************* 
#endrem

#PICAXE 08M2

'Ports
symbol brightPort=C.1
symbol LEDPort=C.2
symbol radarPort=pinC.3
symbol timePort=C.4

'Variables
symbol brightVal=b3
symbol loopCount=w5
symbol maxTime=w6

'Constants
symbol loopTime=150
symbol minTime=60						'The loop count pn CCW of the pot

init:
LOW LEDPort
loopCount=0

main:
if loopCount> 0 THEN
	loopCount = loopCount -1			'DEC is for 8-bit variables only
ELSE
	PWMOUT LEDPort,OFF
ENDIF

PAUSE loopTime

READADC brightPort,brightVal 

IF radarPort = 1 THEN
	READADC10 timePort,maxTime
	PWMOUT LEDPort,63,brightVal
	loopCount = 4 * maxTime + minTime
ENDIF

#rem
IF loopCount = 1 THEN
	SERTXD ("Time=",#maxTime,",Brightness=",#brightVal,13,10)
ENDIF
#endrem
GOTO main
