//Provides constants for scientechMeter to reduce memory requirements. John Saunders 6/17/2023
#include <EEPROM.h>

struct field_t {
  char fldName[10];
  char fldUnit[4];
  float fudge;
  uint8_t decs;
};

typedef char DOW[10];

DOW WeekDays[7] =
{
    "Monday",
    "Tuesday",
    "Wednesday",
    "Thursday",
    "Friday",
    "Saturday",
    "Sunday"
};

struct setting_t {
  char settingType[10];
  char settingName[10];
  char settingParam[6];
  uint8_t settingKey;
};

setting_t settings[5] = {
  {"Select", "txControl", "1 / 0", 1},
  {"Adjust", "txRate",    "Secs",  2},
  {"Select", "DST",       "=",     3},
  {"Adjust", "Minutes",   "Mins=", 4},
  {"Made this", "Saunders" , "John", 0}
};

int eeAddress;

const field_t backFlds[12] = {  //0 - 228
  {"Int 30 V", "V",  26.48f,2}, {"Int 10 V", "V",  8.788f,3}, {"Int 3 V", "V",  2.942f,3},
  {"Int 1 A", "MA",  857.2f,1}, {"Int 0.3 A", "MA",  259.5f,1}, {"Int 0.1 A", "MA",  85.89f,2},
  {"Int 30 MA", "MA",  26.06f,2},  {"Int 10 MA", "MA",  8.768f,3}, {"Int 3 MA", "MA",  2.581f,3},
  {"Int 1 MA", "uA",  867.4f,1}, {"300 uA", "uA",  259.8f,1},  {"100 uA", "uA",  86.33f,2},
};

const field_t extFlds[18] = {  //230 - 554
  {"800 VAC",  "V",   475.0f,1}, {"200 VAC", "V",   128.3f,2}, {"80 VAC", "V",  92.98f,3},
  {"20 VAC",   "V",   13.49f,2}, {"8 VAC",  "V",  5.300f,3}, {"Temp",   "C",  186.1f,1},
  {"800 MA",  "MA",   477.3f,1}, {"200 MA", "MA",  117.7f,1}, {"80 MA", "MA",  47.17f,2},
  {"800 uA",  "uA",   471.7f,1}, {"80 uA", "uA",  46.21f,2}, {"20 uA", "uA",  12.56f,2},
  {"800 mV",   "V",   480.8f,1}, {"2 V",    "V",  1.215f,3}, {"8 V",    "V",  4.965f,3},
  {"20 V",     "V",   12.31f,3}, {"80 V",   "V", 50.39f,2}, {"200 V",  "V",  126.4f,1}
};

void setup() {

  Serial.begin(9600);
  while (!Serial) {
    ; // wait for serial port to connect. Needed for native USB port only
  }

  for (int i = 0; i < 12; i++) {   // 0 to 228
    eeAddress = sizeof(field_t) * i;
    EEPROM.put(eeAddress, backFlds[i]);
  }
  for (int i = 0; i < 18; i++) {   // 230 to 572
    eeAddress = (sizeof(field_t) * i) + 230;
    EEPROM.put(eeAddress, extFlds[i]);
  }

  for (int i = 0; i < 5; i++) {   // 600 to 708
    eeAddress = (sizeof(setting_t) * i) + 600;
    EEPROM.put(eeAddress, settings[i]);
  }

  for (int i = 0; i < 7; i++) {   // 800 to 869
    eeAddress = (sizeof(DOW) * i) + 800;
    EEPROM.put(eeAddress, WeekDays[i]);
  }


  EEPROM.write(1000, 0);     //DST:Standard Time
  EEPROM.write(1001, 0);     //Transmit off
  EEPROM.write(1002, 75);    //Transmit interval in seconds 
  EEPROM.write(1003,  3);    //Rear range
  EEPROM.write(1004, 17);    //Ext range
  EEPROM.write(1005,  3);    //Setting Index
}

void loop() {
  /* Empty loop */
}
