// LISTS.CPP 1.25 -  Definition of field, record, ts, & rlist classes
// 1.02 5/25/93: correct SAVEFILE.RST in rlist::wopen(), etc,
// 1.03 modified rlist::wopen
/* 1.1  All records in  rlist allocated when created(rlist(msgtype),
	rlist(void));invoke delete specifically on records before deleting
	their pointers(~rlist(),empty(),del_rec());use record functons op=,
	add_str(), set_ts(), move() instead of new record(del_rec(),
	copy_rec(),rlist(rlist &), copy_rec(rlist &,int),add_rec(record &),
	add_rec(char *));delete criteria depending on record pointer, use
	Z_FLAG instead(find_rec(ts), find_rec(int), find_trec(), find_sec(),
	display_stats(); added range checks on record/field ints */
// 1.21 Changes ts::ts(char *), getfn * op<< to human-friendly format
// 1.25 Selective storage

#include <stdarg.h>
#define SCOPE extern
#include "globals.h"
// #define ROMVER   BOISE

const int REC_REPORT = 100; // increase in size for reporting

char *fixstream(ostrstream &strm) {
	AcquireMutex(bios_mutex);
	EnterCriticalSection();
        char *fixstr = strm.str();
        LeaveCriticalSection();
        ReleaseMutex(bios_mutex);
        if(fixstr == NULL) endprog = 6;  // 1.21
        return fixstr;
        }

field::field(const char *p) {  // make field from string
	len = strlen(p);
	while(p[len-1]==' '|| p[len-1]=='\t') len--; // trim trailing white space
	ostrstream strm;  // make a dynamic stream
	if(strm.good()) {
		strm.write(p,len);  // copy string
		strm << ends; // add a null
		s = fixstream(strm); // makes s permanent
		}
	if(strm.fail()) {
		endprog = 16;
		s = 0;
		len = 0;
		}
	}

field::field(int size, const char *p) {  // field of fixed size from string
	len = strlen(p);
	if(len > size) len = size;	  // truncate long string
	ostrstream strm;  // make a dynamic stream
	if(strm.good()) {
		strm.write(p,len);  // copy string
		if(len < size){	 // pad if too short
			for(int i = len; i < size; i++) strm << ' ';
			len = size;
			}
		strm << ends; // add a null
		s = fixstream(strm); // makes s permanent
		}
	if(strm.fail()) {
		endprog = 17;
		s = 0;
		len = 0;
		}
	}

field::field(int size, char p=' ') {  // filled string
	len = size;
	ostrstream strm;  // make a dynamic stream
	if(strm.good()) {
		for(int i = 0; i < size; i++) strm << p;
		strm << ends; // add a null
		s = fixstream(strm); // makes s permanent
		}
	if(strm.fail()) {
		endprog = 18;
		s = 0;
		len = 0;
		}
	}

field::~field() {
	if(s) {
		delete []s;	// basic recovery of memory
#ifdef TRACE
	     	trp.displaydigit(4);
#endif
		}
	else {
		endprog = 22;      // 1.1
#ifdef TRACE
	     	trp.displaydigit(5);
#endif
		}
	s = 0;
        len = 0;
	}

field::field(const field & t) {   // copy initializer
	len=t.len;
	ostrstream strm;  // make a dynamic stream
	if(strm.good()) {
		strm.write(t.s,len);  // copy string
		strm << ends; // add a null
		s = fixstream(strm); // makes s permanent
		}
	if(strm.fail()) {
		endprog = 19;
		s = 0;
		len = 0;
		}
	}

int field::getn(void) const {
	if(len > MAX_CHAR + 10 || len < 0) {
		endprog = 21;
                cerr << "len out of range:" << len << "\n\r";
		return 0;
		}
	return len;
	}

void field::trim(void) {
	int newlen = len;
	while(s[newlen-1] == ' ' || s[newlen - 1] == '\t') newlen --;
	if(newlen != len) { // make new string
		ostrstream strm;  // make a dynamic stream
		if(strm.good()) {
			strm.write(s,newlen);  // copy string
			strm << ends; // add a null
			if(s) delete []s;		// don't need old string anymore
			s = fixstream(strm); // makes s permanent
			}
		if(strm.fail()) {
			endprog = 14;
			s = 0;
			len = 0;
			}
		else len = newlen;
		}
	}

int field::getfs(int m, char *o) const { // copies into string, will not exceed its length
	int l = len;
	if(l >= m) l = m - 1;
	ostrstream strm(o,l+5);  // make a stream with o
	if(strm.good()) {
		strm << s << ends;
		} // add a null
	else {
		*o = '\0';
	l  = 0;
		}
	return l;
	}

field &field::operator=(const field &s1) { // overload =, changes this
	int newlen = s1.len;
	ostrstream strm;  // make a dynamic stream
	if(strm.good()) {
		strm.write(s1.s,newlen);  // copy string
		strm << ends; // add a null
		}
	if(s) delete []s;		// don't need old string anymore
	s = fixstream(strm); // makes s permanent
	if(strm.fail()) {
		endprog = 20;
		s = 0;
		len = 0;
		}
	return *this;
	}

field &operator+(const field &s1, const field &s2) { // catenation
	field *newfld;
	newfld = new field(s1.len + s2.len + 1); // filled with spaces
	if(newfld) {
		newfld->len = s1.len + s2.len;
		ostrstream strm(newfld->s,newfld->len + 1);
		if(strm.good()) {
			strm.write(s1.s,s1.len);  // copy first string
			strm.write(s2.s,s2.len);  // copy second string
			strm << ends; // add a null
			}
		}
	field &fptr = *newfld;
	return fptr;
	}

int operator==(const field &s1, const field &s2) {
	if(s1.len != s2.len) return 0;
	for(int i=0;i<s1.len;i++) if(s1.s[i] != s2.s[i]) return 0;
	return 1;
	}

int operator!=(const field &s1, const field &s2) {
	if(s1.len != s2.len) return 1;
	for(int i=0;i<s1.len;i++) if(s1.s[i] != s2.s[i]) return 1;
	return 0;
	}
#ifndef ROMVER


int operator>(const field &s1, const field &s2)  {
	int comn;
	comn = (s1.len > s2.len) ? s1.len : s2.len; // get common length
	for(int i = 0; i < comn; i++) {
	   if(s1.s[i] > s2.s[i]) return 1;
	   if(s1.s[i] < s2.s[i]) return 0;
	   }
	// must be the same in common length, longer string is higher
	if(s1.len > s2.len) return 1;
	return 0;
	}

int operator>=(const field &s1, const field &s2) {
	int comn;
	comn = (s1.len > s2.len) ? s1.len : s2.len;
	for(int i = 0; i < comn; i++) {
	   if(s1.s[i] > s2.s[i]) return 1;
	   if(s1.s[i] < s2.s[i]) return 0;
	   }
	// must be the same in common length, shorter string is lower
	if(s1.len >= s2.len) return 1;
	return 0;
	}

int operator<(const field &s1, const field &s2)  {
	int comn;
	comn = (s1.len > s2.len) ? s1.len : s2.len;
	for(int i = 0; i < comn; i++) {
	   if(s1.s[i] < s2.s[i]) return 1;
	   if(s1.s[i] > s2.s[i]) return 0;
	   }
	// must be the same in common length, longer string is higher
	if(s1.len < s2.len) return 1;
	return 0;
	}

int operator<=(const field &s1, const field &s2) {
	int comn;
	comn = (s1.len > s2.len) ? s1.len : s2.len;
	for(int i = 0; i < comn; i++) {
	   if(s1.s[i] < s2.s[i]) return 1;
	   if(s1.s[i] > s2.s[i]) return 0;
	   }
	// must be the same in common length, longer string is higher
	if(s1.len <= s2.len) return 1;
	return 0;
	}

int field::operator&(const field &f1) {
	int i,j;
	if(f1.len > len) return 0;
	for(i=0;i<=(len-f1.len);i++) {
		for(j=0;j<f1.len;j++) {
			if(f1.s[j] != s[j+i]) break;
			}
		if(j==f1.len) break;
		}
	if(j==f1.len) return i+1;
	return 0;
	}
#endif

char field::operator[](int n) const {
	int pos = n;
	if(n < 0) pos = 0;   // avoid bounds violation
	if(n >= len) pos = len - 1;
	char &retc = s[pos];
	return retc;
	}

ostream &operator<<(ostream &str, const field &f1) {
	str << f1.s;
	return str;
	}

ts::ts(const char *s) {  // convert a filename in hex format
	struct tm t;
        t.tm_year = cv_an_int(s[0]) + 90;
        t.tm_mon  = cv_an_int(s[1]);
	t.tm_mday = cv_an_int(s[2]) + 1;
        t.tm_hour = cv_an_int(s[3]);
        t.tm_min  = 10*(int)s[4] + (int)s[5] - 528;
        t.tm_sec  = 10*(int)s[6] + (int)s[7] - 528;
        secs = mktime(&t);
        if(!valid()) secs = 0;
	}

time_t operator-(const ts &t1, const ts &t2) {
	return (t1.secs - t2.secs); }

int ts::getts(char *s1) const {  // format: mm/dd/yyyy hr:min:sec
	struct tm *dt = localtime(&secs);
	ostrstream sout(s1,20);  // declares an output string
	if(sout.good() && valid()) {
		sout.width(2);   // each field is of width 2 characters
        sout.fill('0');
		sout << dt->tm_mon + 1;
		sout.width(2);   // each field is of width 2 characters
        sout.fill('0');
		sout << '/' << dt->tm_mday << '/' << (dt->tm_year+1900) << ' ';
		sout.width(2);   // each field is of width 2 characters
        sout.fill('0');
		sout << dt->tm_hour << ':';
        sout.fill('0');
		sout.width(2);   // each field is of width 2 characters
		sout << dt->tm_min << ':';
		sout.width(2);   // each field is of width 2 characters
        sout.fill('0');
		sout << dt->tm_sec << ends;  // adds a null
		}
	return strlen(s1);
	}

ts &ts::operator=(const ts &t1) {
	time_t newsec=t1.secs;
	secs = newsec;
	return *this;
	}

int ts::getfn(char *s1) const { // use string with length 9 or more
        if(valid()) {
		struct tm *t;
	        t = localtime(&secs);
                s1[0] = cv_int_an(t->tm_year - 90);
		s1[1] = cv_int_an(t->tm_mon);
                s1[2] = cv_int_an(t->tm_mday - 1);
                s1[3] = cv_int_an(t->tm_hour);
		s1[4] = (char)(t->tm_min/10 + 48);
		s1[5] = (char)(t->tm_min%10 + 48);
		s1[6] = (char)(t->tm_sec/10 + 48);
		s1[7] = (char)(t->tm_sec%10 + 48);
                s1[8] = '\0';
                return 8;
                }
	else {
		strcpy(s1,"20abcdef");
		return -8;
        	}
	}

ostream &operator<<(ostream &str, const ts &t1) {
	if(t1.valid()) {
	        char strng[9];
        	t1.getfn(strng);
		str << strng;
                }
	else str << "20ab5959";
	return str;
	}

int record::add_str(const char *s1, char sep_char) { // add string to this with separators
	int add_sep = 0;
	if(len > 1 && (s[len-1] != SEP && s[len-1] != CR  &&
	   s[len-1] != LF) || sep_char != SEP) add_sep = 1;
	for(int i = 0; i < MAX_CHAR-len-add_sep; i++) { // if delimiters embedded
		if(s1[i] == CR) nf++; // increment number of lines
		if(s1[i] < ' ' && (s1[i] != LF && s1[i] != CR &&
			s1[i] != FS && s1[i] != STX)) break;
		}
	if(i == 0) return -1; // nothing to add
	ostrstream strm;  // make a dynamic stream
	if(strm.good()) {
		if(len > 0 && s) { // if not old null string
    	    		strm.write(s,len);
			delete []s;	   // delete old string
       			s = 0;
			if(add_sep) strm << sep_char;  // add separator
			}
		strm.write(s1,i); // add the new string
		nf++;             // for the new string
		strm << ends;
		s = fixstream(strm); // makes s permanent
		}
	if(strm.fail()) {
		flag = Z_FLAG;
		len = 0;
	s = 0;
	endprog = 6;
		return -1;
		}
	else {
		len = strlen(s);	  // revise length
		flag = N_FLAG;
		}
	return len;
	}

/*  ... won't start
int record::add_str(const char *s1, char sep_char) { // 1.21 add string to this with separators
	ostrstream strm;  // make a dynamic stream
	if(!strm.good()) {
        	endprog = 6;
                return -1;
                }
	if(len > 0 && s) { // if not old null string
    		strm.write(s,len);
                }
	if(len > 1 && (s[len-1] != SEP && s[len-1] != CR  &&
	   s[len-1] != LF) || sep_char != SEP) {
		strm << sep_char;  // add separator
                len++;
                }
        if(s) {
        	delete []s;	   // delete old string
       		s = 0;
        	}
        int j = 0;
	for(int i = 0; i < MAX_CHAR-len; i++) {
                if(s1[i] == CR || s1[i] == LF) { // if delimiters embedded
                        if(i > 0 && i > j) {
				strm.write(s1+j,i-j);
                                len += i-j;
                                }
                	strm << '\r';
			if(s1[i+1] != LF && s1[i+1] != CR) {
                                len ++; // adds a character
                                }
                        else i++;  // skip it
			strm << '\n';
                        nf++;
                        j = i + 1;
                	}
                len ++;
		if(s1[i] < ' ' && (s1[i] != LF && s1[i] != CR &&
			s1[i] != FS && s1[i] != STX)) break; // end of input
		}
	if(i > 0 && i > j) {  // write the rest
		strm.write(s1+j,i-j);
                len += i-j;
                nf++;
                }
	strm << ends;
	s = fixstream(strm); // makes s permanent
	flag = N_FLAG;
	return len;
	}
*/
// these constructors with variable number of parameters use the varargs
// macro of stdarg.h. This first one also sets the timestamp
// this constructor has been mashed to prevent ambiguity
record::record(const ts &t, int numfld, const char *s1, ...):created(t) {
	nf=0;
	len = 0;
	seqno = -1;
	char *sptr;
	flag = Z_FLAG;
	if(s1 != NULL) {
		va_list p;	 // start macro, p is a pointer
		va_start(p,s1);  // point to last fixed parameter
		if(add_str(s1) < 0)  return;  // add s1 to the null string
		for(int i=1; i < numfld; i++) {
			sptr = va_arg(p,char *);
			if(sptr == NULL) break;
			if(add_str(sptr) < 0) break; // adds to string
			}
		va_end(p);
		}
	}

record::record(const char *s1, ...) {  // automatically uses present time
	nf = 0;
	len = 0;
	flag = Z_FLAG;
	seqno = -1;
	if(s1 != NULL) {
		va_list p;
		va_start(p,s1);
		add_str(s1);
		char *strngptr;
		while((strngptr = va_arg(p,char *)) != NULL) {
			if(add_str(strngptr) < 0) break;
			}
		va_end(p);
		}
	}

record::record(const int numfld, const char *s1, ...) { // specified number
	nf = 0;
	len = 0;
	flag = Z_FLAG;
	seqno = -1;
	if(s1 != NULL && numfld > 0) {
		va_list p;
		va_start(p,s1);
		if(add_str(s1) < 0) return;
		char *strngptr;
		for(int i=1; i<numfld; i++) {
			strngptr = va_arg(p,char *);
			if(strngptr == NULL) break;
			if(add_str(strngptr) < 0) break;  // make sure there is one
			}
		va_end(p);
		}
	}

record::~record() {
	flag = Z_FLAG;
	}

int record::get_flag(void) {
	if(flag > C_FLAG || flag < 0) {
		endprog = 21;
                cerr << "Flag out of range:" << flag << "\n\r";
		return Z_FLAG;
		}
	return flag;
	}


#ifdef ROMVER
int record::add_fld(const field &f1) {  // add to end
	int l = f1.getn();
	if(l > 0) {
		char *rtemp;
		rtemp = new char(l + 1);
		if(rtemp) {
			f1.getfs(l+1,rtemp);
			if(add_str(rtemp) < 0) {
				flag = Z_FLAG;
				return -1;
				}
			delete []rtemp;
			}
	rtemp = 0;
		}
	flag = N_FLAG;
	return len;
	}
#endif

int record::get_nf(void) const {
	if((nf > MAX_CHAR/2 || nf < 1) && flag != Z_FLAG) {
		endprog = 21;
                cerr << "nf out of range:" << nf << "\n\r";
		return 0;
		}
	return nf;
	}

record &record::operator=(const record &r1) {
	if(s) delete []s;		  // delete old string
	s = 0;
	ostrstream strm;  // make a dynamic stream
	if(strm.good() && r1.s && r1.len > 0) { // if not null string
		len = r1.len;	  // revise length
		created = r1.created;
		seqno = r1.seqno;
		nf = r1.nf;
		flag = r1.flag;
		strm << r1.s << ends;  // copy string
		s = fixstream(strm); // makes s permanent
		if(strm.fail()) {
			flag = Z_FLAG;
			s = 0;
			len = 0;
			}
		}
	else {
		flag = Z_FLAG;
		len = 0;
		s = 0;
		endprog = 7;  // moved 1.22, fixstream sets 6
		}
	return *this;
	}

void record::move(record & r1) { // moves parameters
	len = r1.len;	  // revise length
	created = r1.created;
	seqno = r1.seqno;
	nf = r1.nf;
	flag = r1.flag;
	if(s) delete []s;
	s = r1.s;
	r1.s = 0;
	r1.len = 0;
	r1.flag = Z_FLAG;
	}

record::record(const record &r1) {
//	created = r1.created; deleted 10-22-92 to get current timestamp
	if(r1.flag != Z_FLAG) {
		nf = r1.nf;
		len = r1.len;
		seqno = r1.seqno;
		flag = N_FLAG;  // counts as new record
		ostrstream strm;  // make a dynamic stream
		if(strm.good()) strm << r1.s << ends; // add a null
		s = fixstream(strm); // makes s permanent
		if(strm.fail()) {
			flag = Z_FLAG;
			endprog = 8;
			s = 0;
			len = 0;
			}
		}
	else {
		flag = Z_FLAG;
		len = 0;
		s = 0;
		}
	}

void record::set_flag(int fl) {
	if(fl > C_FLAG || fl < 0) return;
	if(fl == RETRY_FLAG) {
		if(flag > 0 && flag < MAX_CCF_RETRY) flag++;
		if(flag > 15 && flag < 16 + MAX_CCF_RETRY) flag -= 15;
		if(flag == N_FLAG) flag = 0;
		if(flag == MAX_CCF_RETRY) flag = E_FLAG;
		}
	else flag = fl;
	}

int record::get_fld(int index, char *s1) {
	if(flag == Z_FLAG) return -259;
	int nsep=index,i=0,start=0,sepcount=0;
	if(nsep < 0) nsep=0;
// if(nsep >= nf) nsep=nf-1;
	char ch;
	while((ch=s[i]) != '\0' && i < len) {
		if(ch == SEP || ch == STX) {	   // 1/13/93 add STX
			sepcount++;
			if(sepcount > nsep || ch == '\0') break;
			start = i + 1;
			}
		i++;
		}
	ostrstream strm(s1,MAX_CHAR);
	if(strm.good()) {
		strm.write((s+start),(i-start));
		strm << ends;
		i = start - 1;
		}
	return (i - start);
	}

// outputs a record, encoded flag is firat character,encoded number of lines
// is second, 8-char timestamp is next, ends with a '$' on its own line
// returns length of string, or -ve

int record::get_str(int m, char *s1) {   // m governs space in the string
	if(flag == Z_FLAG || m < len + 15) return -259;
	if(s1 == 0 || s == 0 || len == 0) return -1;
	s1[0] = flag + '0';
	if(nf < 27) s1[1] = nf + 'A';
	if(nf > 26 && nf < 53) s1[1] = nf + 'F';
	if(nf > 52) s1[1] = ']';
	ostrstream strm(s1 + 2, m);
	if(strm.good()) {
		strm << created <<   // get timestamp as 8-char string
			SEP << s <<	 // add a comma, then the data
                        NL << '$' << NL << ends; // delimits the record in the file
		return len + 12 + 2*strlen(NL);
		}
        else return -1;
	}

/*
void record::del_fld(int index) {
	if(index >= len) { // delete all
		if(s) delete []s;
        	s = 0;
		nf = 0;
		flag = Z_FLAG;
		len = 0;
		return;
		}
	int nsep=index,i=0,start=0,sepcount=0;
	if(nsep < 0) nsep=0;
	if(nsep >= nf) nsep=nf-1;
	char ch;
	while((ch=s[i]) != '\0') {
		if(ch == SEP || ch == STX) {   // STX added 1/13/93
			sepcount++;
			if(sepcount > nsep) break;
			if(sepcount == nsep && nsep > 0) start = i;
			}
		i++;
		}
	ostrstream strm;  // make a dynamic stream
	char *newstr;
	if(start > 0) {  // if not first section
		strm.write(s,i);		// copy beginning sections
		}
	else i++;
	if(nsep < (nf-1)) {  // if not last section
		strm.write(s+i,(len - i));
			}
	if(s) delete []s;		  // delete old string
	strm << ends;
	s = fixstream(strm); // makes s permanent
	len -= i - start;	  // revise length
	nf --;
	if(nf < 1 || strm.bad()) flag = Z_FLAG;
	}
*/

rlist::rlist(const msgtype t) {
	type = t;
        int num_entries = Tint[getix(type)].recs;
        next = 0;
        last = 0;
        max_rec = (num_entries >= 2*MIN_DUMP) ? num_entries : 2*MIN_DUMP;
        if(max_rec > MAX_POINTERS) max_rec = MAX_POINTERS;
	stat_change = 1;
	if(getix(t) >= 0) f = N_FLAG;
	nrec=0;
	plen = strlen(path) + 5;
	strcpy(fname,path);  // put in the path
	fname[plen - 5] = 92;	// '\'
	GetTypeCode(fname + plen - 4,type); // subdirectory
	fname[plen - 1] = 92;
	for(int i = 0; i < max_rec; i++)
		list[i] = new record; // create null records
	windx = -1;
#ifndef ROMVER
	if(load("SAVEFILE.RST") > 0)  {
		strcpy(fname + plen,"SAVEFILE.RST");
		AcquireMutex(bios_mutex); // 1.02 added
		unlink(fname); // delete to prevent reuse
		ReleaseMutex(bios_mutex); // 1.02 added
		}
#endif
	}

rlist::rlist(const rlist &r1) { // new origin timestamp
	nrec = r1.nrec;
	f = r1.f;
	type = r1.type;
        max_rec = r1.max_rec;
	strcpy(fname,r1.fname);
	for(int i = 0; i < nrec; i++) list[i] = new record(*r1.list[i]);
	for(i = nrec; i < max_rec; i++) list[i] = new record;
	plen = r1.plen;
	if(r1.windx >= 0 && type != log_msg)
		log(type,"Active rlist copy",r1.windx,1);
	windx = -1;
	stat_change = 1;
        next = r1.next;
        last = r1.last;
	}

rlist::rlist(void) {
	nrec = 0;
        next = 0;
        max_rec = 2*MIN_DUMP;
	f = Z_FLAG;
	type = invtype;
	plen=strlen(path) + 5;
	strcpy(fname,path);  // put in the path
	fname[plen - 5] = 92;	// '\'
	strcpy(fname + plen - 4,"IVT");
	fname[plen-1] = 92;
	origin.getfn(fname + plen);
	strcpy(fname + plen + 8,".LST");
	for(int i = 0; i < max_rec; i++) list[i] = new record;
	windx = -1;
	stat_change = 0;
	log(invtype,"Warning: default rlist created",0,1);
	}

rlist::~rlist() {
	if(endprog == 4) return; // heap corupt;don't even dare delete, 1.02
#ifndef ROMVER
	if(nrec > 0 && f == N_FLAG && msc.get_disk_free() > MIN_DISK_FREE) { // no records or corrupt heap
		int np;
		np = find_rec(N_FLAG);
		if(np >= 0) { // save this index and higher in SAVEFILE.RST
			if(this->wopen(-1) > 0) { // open SAVEFILE, start at np
				windx = np;
				while(wnext(nrec-1) > 0);
				diskclose(nrec - np);
				}
			}
		else np = nrec; // save all
		if(type == log_msg) np = nrec;
		if(np > 0) {
			if(this->wopen(np-1) > 0) { // open archive file per header and newest
				windx = 0;
				while(wnext(np-1) != 0); // returns 0 to -2 if finished
				diskclose(np);
				}
			}
		}
/*	else if(type != log_msg && nrec > 0)
		log(type,"rlist not written, f = ",f,8); 1.02 deleted */
#endif
	AcquireMutex(rlist_mutex);
	for(int i = nrec-1; i >= 0; i--) { // reverse order, 2/12/93
		if(list[i]) {
//			list[i]->field::~field(); // 1.21 compiler deletes
			delete list[i]; // delete the records
			list[i] = 0;
			}
		}
	ReleaseMutex(rlist_mutex);
	nrec = 0;
	stat_change = 0;
	}

int rlist::empty(void) {
	if(nrec > 0 && type != log_msg) log(type,"List Emptied",nrec,8);
	AcquireMutex(rlist_mutex);
	for(int i = nrec - 1; i >= 0; i--) { // reverse order, 2/12/93
		if(list[i]) {
			list[i]->field::~field();
			list[i]->set_flag(Z_FLAG); // 1.22
			}
		}
	nrec = 0;
	ReleaseMutex(rlist_mutex);
	stat_change = 1;
	return i;
	}

int rlist::add_rec(const record &r1) {
	int i = -2;
	if(nrec < max_rec && f != Z_FLAG && r1.getn()) {
		AcquireMutex(rlist_mutex);
		*list[nrec] = r1; // = overload
		if(endprog == 0) { // endprog set if new fails
			i = nrec;
			nrec++;
			if(nrec>1) {  // check sort, usually correct already
				record *rptr;
				while((list[i]->get_ts()-list[i-1]->get_ts())<0) {
					rptr=list[i-1];
					list[i-1]=list[i];
					list[i]=rptr;
					if(i==1) break;
					else i--;
					}
				}
			}
		else i = -1;  // none added
		ReleaseMutex(rlist_mutex);
		}
	stat_change = 1;
	return i;
	}

// these return index to the added record
int rlist::add_rec(const char *s1) { // from message or file
	int i = -2;
	if(endprog == 4) return i; // corrupt heap
	if(nrec < max_rec && f != Z_FLAG && strlen(s1)) {
		AcquireMutex(rlist_mutex);
                EnterCriticalSection();
                if(list[nrec]->getn() > 0) list[nrec]->field::~field();
 		if(strlen(s1) > 11 && s1[10] == SEP) { // may be a timestamp here
			ts newcreat(s1+2); // make temp timestamp from string next 8 bytes
			if(newcreat.valid()) { // time stamp in this string
				list[nrec]->set_ts(newcreat);
				list[nrec]->add_str(s1+11);
				list[nrec]->set_flag(s1[0] - '0'); // 1.21
				}
			else  // no valid timestamp
				list[nrec]->set_ts(); // reset timestamp
				list[nrec]->add_str(s1); // start immediately
			}
		else  { // Also no timestamp in string
				list[nrec]->set_ts(); // reset timestamp
				list[nrec]->add_str(s1); // start immediately
				}
		i = nrec;
		if(nrec < max_rec - 1) nrec++;
		if(nrec>1) {  // check sort, usually correct already
			record *rptr;
			while((list[i]->get_ts()-list[i-1]->get_ts())<0) {
				rptr=list[i-1];
				list[i-1]=list[i];
				list[i]=rptr;
				if(i==1) break;
				else i--;
				}
			}
		LeaveCriticalSection();
		ReleaseMutex(rlist_mutex);
		}
	stat_change = 1;
	return i;
	}

record &rlist::operator[](int index) {
	if(index >= 0 && index < nrec &&
	    list[index]->get_flag() != Z_FLAG) {
		record &rptr = *list[index];
		return rptr;
		}
	else {
		record &rptr = exch.rdefault;
		return rptr;
		}
	}

rlist &rlist::operator=(const rlist &r1) {
	origin = r1.origin;
	f = r1.f;
	type = r1.type;
	strcpy(fname,r1.fname);
	plen = r1.plen;
	this->empty(); // delete all old data
	AcquireMutex(rlist_mutex);
	nrec = r1.nrec;
	for(int i = 0; i < nrec; i++) list[i] = new record(*r1.list[i]); // 1.21 copy good
	ReleaseMutex(rlist_mutex);
	if(r1.windx >= 0 && type != log_msg)
		log(r1.type,"Active rlist assignment",r1.windx,1);
	windx = -1;
	stat_change = 1;
	return *this;
	}

int rlist::copy_rec(const rlist &rl1, int indx) { // copy record at index to end
	if(nrec < max_rec && f != Z_FLAG && indx >=0 && indx < rl1.get_nrec()
		&& rl1.list[indx]->getn()) {   // 1.21
		AcquireMutex(rlist_mutex);
		*list[nrec] = *rl1.list[indx]; // 1.21
		nrec++;
		ReleaseMutex(rlist_mutex);
		}
	else return -1;
	stat_change = 1;
	return nrec;
	}


int rlist::del_rec(int del_num) { // transfer older records
	static int old_size = 0;
	int num = del_num;
	int no_done = debug_level.v & NOT_DONE_ONLY;
	if(del_num >= max_rec) num = nrec;
	if(del_num == 0) { // default case
		num = find_rec(D_FLAG);
		if(nrec - old_size > REC_REPORT) {
			b_flag = 10;	 // report rlist stats
			c_flag = 1;	 // report communications stats
			old_size = nrec;
			}
		if(num < MIN_DUMP && nrec < ((2*max_rec) / 3))
			return 0; // ineligible to archive, 1.03 was 1/2
		if(nrec >= ((2 * max_rec) / 3) && num < max_rec/3) {
			num = MIN_DUMP; // 1.22
			no_done = 0;
			}
		}
#ifdef TRACE
	trp.displaydigit(getix(type));
	trp.displaydigit(num);
#endif
	if(num < 1) return 0;
#ifndef ROMVER
	windx = 0;   // moved, wopen may change it
	if(msc.get_disk_free() > MIN_DISK_FREE && (type == mbc_data ||
	    (debug_level.v & MBD_ONLY) == 0) && no_done == 0) {
		if(this->wopen(num - 1) < 0) return -3; // open file according to header and newest
		while(wnext(num - 1) != 0); // returns 0 when closed, neg for error
		diskclose(num);
		}
#endif
	AcquireMutex(rlist_mutex);
	for(int i = num - 1 ;(i  >= 0 && i < nrec); i--) { // empty the archived records
		if(list[i + num]->get_flag() != Z_FLAG && i + num < nrec) {
			list[i]->move(*list[i + num]);
			}
		else {
			list[i]->field::~field();  // 1.22
			list[i]->set_flag(Z_FLAG);
                	}
                }
	nrec -= num;
	ReleaseMutex(rlist_mutex);
	stat_change = 1;
	return num;
	}

int rlist::find_trec(const ts &t1) {
	if(nrec==0) return -1;
	if(nrec==1) return 0;
	for(int i=0; i<nrec; i++) {	 // change to binary search later
		if((list[i]->get_ts() - t1) > 0) break;
		}
	if(i==nrec) i--;
	return i;
	}

int rlist::find_rec(int f1) const { // get index with flag==f1 or return -1
	if(nrec==0) return -1;
	AcquireMutex(rlist_mutex);  // 1.02 added
	int ret = -2;
	int tf;
	for(int i = 0; i < nrec; i++) {	 // change to binary search later
		tf = list[i]->get_flag();
		if(tf == Z_FLAG || list[i]->getn() == 0) continue;
		switch(f1) {
			case RETRY_FLAG: if(tf == N_FLAG ||
				(tf > 15 && tf < 16 + MAX_CCF_RETRY)) ret = i; break;
			case D_FLAG: if((tf != D_FLAG && tf != E_FLAG &&
				tf != Z_FLAG && tf != R_FLAG) ||
				i == nrec - 1) ret = i - 1;
				break;
			default: if(tf == f1) ret = i;
			}
		if(ret >= 0) break;
		}
	ReleaseMutex(rlist_mutex); // 1.02 added
	return ret;
	}

int rlist::find_seq(int sq1) const { // get lowest sequence number
	if(nrec==0) return -1;
	int ret = -2;
	AcquireMutex(rlist_mutex);
	for(int i=0; i<nrec; i++) {	 // change to binary search later
		if(list[i]->get_flag() != Z_FLAG) {
			if(list[i]->get_seqno() == sq1) {
				ret = i;
				break;
				}
			}
		else break;
		}
	ReleaseMutex(rlist_mutex);
	if(i==nrec) ret = -3;
	return ret;
	}

int operator==(const rlist &r1, const rlist &r2) {
	return(r1.type == r2.type); // true if type equal
	}

#ifndef ROMVER
// 5/10/93: logic for using SAVEFILE.RST
// 5/25/93: correct placement of "LST" copy

int rlist::wopen(int time_rec) { // index of record to make filename
	if(nrec == 0 || f == Z_FLAG || getix(type) < 0 || list[0] == NULL) {
		return -1;  // nothing to store
		}
	if(time_rec > MAX_POINTERS) time_rec = nrec-1;
	if(time_rec < 0) { //  for SAVEFILE
		strcpy(fname+plen,"SAVEFILE.RST"); // for program abort/restart
		}
	else {
		while(time_rec >= 0 && list[time_rec]->get_flag() == Z_FLAG)
		    time_rec--;   // 1.22 check the record content
		list[time_rec]->get_ts().getfn(fname+plen);
        	strcpy(fname+plen+8,".LST");
	    }
	AcquireMutex(bios_mutex);
	diskstrm.open(fname,ios::out|ios::binary);
	ReleaseMutex(bios_mutex);
	int ret = diskstrm.rdstate();
	if(ret) {
		if(type != log_msg) log(type,fname,f*100+ret,5);
		else cerr << "failure to open logfile for writing:" << ret << endl;
		windx = -1;
		diskstrm.clear();
		return -2; // cannot open
		}
	return plen;
	}

int rlist::ropen(const ts &t1) {
	ts newer;		  // must be newer than t1
	strcpy(fname+plen,"*.LST");
	struct ffblk f;
	AcquireMutex(bios_mutex);
	int done = findfirst(fname,&f,0); // get first matching name
	ReleaseMutex(bios_mutex);
	int found = 0;
	if(done == 0) {
		found = 1;
		ts tmpts(f.ff_name);  // filename encodes date of newest record
		if((tmpts - t1) >= 0) newer = tmpts; // not interested in older files
		}
	while (found && !done) {
		AcquireMutex(bios_mutex);
		done = findnext(&f); // get next matching name
		ReleaseMutex(bios_mutex);
		if(done == 0) {
			found++;
			ts tmpts(f.ff_name);
			if((tmpts - t1) >= 0 && (newer - tmpts) > 0) {
				newer = tmpts; // closer to t1
				}
			}
		}
	if(! found) {
		if(type != log_msg) log(type, "Read file find failed", done, 3);
		return -1;
		}
	newer.getfn(fname+plen); // generate the filename
	strcpy(fname+plen+8,".LST"); // add the extension
	AcquireMutex(bios_mutex);
	diskstrm.open(fname,ios::in|ios::binary);
	ReleaseMutex(bios_mutex);
	if(! diskstrm) {
		if(type != log_msg) log(type,"Read Open Failed",diskstrm.rdstate(),3);
		return -2;
		}
	else {
		if(type != log_msg) log(type,fname,nrec,5);
		return plen;
		}
	}

void rlist::diskclose(int np = 0) {
	if(np == 0) np = nrec;
	diskstrm.close();
	int ret = diskstrm.rdstate();
	if(type != log_msg) log(type,fname,1000*ret+np,5);
	else if(endprog) cerr << "logfile " << fname << " closed:state/records =" << 1000*ret+np << endl;
	if(! diskstrm) diskstrm.clear();
	sleep(1);
	windx = -1;
	}

int rlist::rnext(void) {   // for records separated by lines beginning with a $
	int used = 0;
	char marker;
	do {
		AcquireMutex(bios_mutex);
		diskstrm.get(marker);
		ReleaseMutex(bios_mutex);
		if(marker == '$') break;
		*(msc.diskbuf+ used) = marker;
		AcquireMutex(bios_mutex);
		diskstrm.getline(msc.diskbuf+used+1,MAX_CHAR-used); // get one line into msc.diskbuf
		ReleaseMutex(bios_mutex);
		strcat(msc.diskbuf,"\n");
		used = strlen(msc.diskbuf);
		}
	while(! diskstrm.eof() && used<MAX_CHAR);
	int ret = add_rec(msc.diskbuf);
	if(diskstrm.eof()) return -1;
	else return ret;
	}

int rlist::wnext(int recn) { // index of record to be last stored
	int last_rec = recn;     // windx is the first record
	if(recn >= nrec || recn < 0) last_rec = nrec - 1;
	if(windx < 0 || ! diskstrm || f == Z_FLAG) return -2;
	while(list[windx] == NULL || list[windx]->get_flag() == Z_FLAG ||
		list[windx]->getn() == 0) {   // skip bad records
		if(windx >= last_rec) return 0;
		windx++;
		}
	int buflen = list[windx]->get_str(MAX_CHAR, msc.diskbuf);  // 0 is OK return
	if(buflen > 0) {  // only write valid strings
		AcquireMutex(bios_mutex);
		diskstrm.write(msc.diskbuf,buflen);	 // 1.22 send to file
		ReleaseMutex(bios_mutex);
		}
	if(diskstrm.fail()) {
		cerr << "failure to write " << type << " record " << windx << endl;
		diskstrm.clear();
		return -1;  // bad write or bad record
		}
	if(windx >= last_rec) return 0; // normal exit
	windx++;
	return windx;
	}
int rlist::load(const char *s) {  // used for multi-line records with $ delimiter
	if(f == Z_FLAG) return -2;
	if(strncmpi(s,"SAVEFILE.RST",12)) f = E_FLAG;   // signifies a fixed rlist
	strcpy(fname+plen,s);
//	AcquireMutex(disk_mutex);
	diskstrm.open(fname,ios::in);
	if(! diskstrm) {
		if(f == E_FLAG) {
			log(type,fname,diskstrm.rdstate(),3);
			f = Z_FLAG;
			}
		}
	else {
		int used;
		do {
			used = 0;
			while(!diskstrm.eof()&&used<MAX_CHAR) {
				diskstrm.getline(msc.diskbuf+used,MAX_CHAR-used); // get one line into diskbuf
				if(msc.diskbuf[used] == '$') { // end of record
					if(used > 1) {
						msc.diskbuf[used-1] = '\0'; // del newline & $
						if(add_rec(msc.diskbuf) < 0) break;
						}
					break;
					}
				used = strlen(msc.diskbuf);
				msc.diskbuf[used++] = '\n';
				msc.diskbuf[used++] = '\r';
				}
			}
		while(!diskstrm.eof());
		diskclose();
		}
//	ReleaseMutex(disk_mutex);
//	if(nrec > 0 && type != log_msg) log(type, fname, nrec, 5); 1.03 deleted
	stat_change = 1;
	return nrec;
	}

/* above is 1.03 version
int rlist::load(const char *s) {  // used for multi-line records with $ delimiter
	if(f == Z_FLAG) return -2;
	if(strncmpi(s,"SAVEFILE.RST",12)) f = E_FLAG;   // signifies a fixed rlist
	strcpy(fname+plen,s);
	diskstrm.open(fname,ios::in|ios::binary);
	if(! diskstrm) {
		if(f == E_FLAG) {
			log(type,fname,diskstrm.rdstate(),3);
			f = Z_FLAG;
			}
		}
	else {
		int used,off;
		do {
			used = 0;
			while(!diskstrm.eof()) {
				diskstrm.getline(msc.diskbuf+used,MAX_CHAR-used,'$'); // get one line into diskbuf
				used = strlen(msc.diskbuf);
                                if(msc.diskbuf[used-1] == LF ||
					msc.diskbuf[used-1] == CR ||
					used >= MAX_CHAR) {
					while(msc.diskbuf[used-1] == LF ||
					msc.diskbuf[used-1] == CR) used--;
					msc.diskbuf[used] = EOT;
					msc.diskbuf[used + 1] = '\0';                                        msc.diskbuf[used-1] = ETX;
                                        off = 0;
                                        while(msc.diskbuf[off] == LF ||
						msc.diskbuf[off] == CR) {
						off++;
                                                }
					if(used > 11) add_rec(msc.diskbuf + off);
					break;
                                        }
				}
			}
		while(!diskstrm.eof());
		diskclose();
		}
//	if(nrec > 0 && type != log_msg) log(type, fname, nrec, 5); 1.03 deleted
	stat_change = 1;
	return nrec;
	}
*/
#endif

const char R_SEP = ',';   // separator for rlist statistics

ostream &operator<<(ostream &strm, const rlist &r1) {
	strm << NL << r1.type << R_SEP <<    // 1.21 was "\r\n"
	r1.origin << R_SEP; // creation time
	if(r1.nrec > 0) {
		strm << r1.list[0]->get_ts() << R_SEP ; // time of oldest record
		int i = r1.find_rec(D_FLAG);
		strm.width(3);   // field is of width 3 characters
		strm.fill('0');		 // pad with zeroes
		if(i > 0)
			strm << dec << i << R_SEP << r1.list[i]->get_ts();
		else strm << "None Done";
		strm.width(3);   // field is of width 3 characters
		strm.fill('0');		 // pad with zeroes
		strm << R_SEP << dec << r1.nrec << R_SEP
			<< r1.list[r1.nrec - 1]->get_ts(); // newest time
		}
	else strm << "Empty";
	return strm;
	}

void rlist::display_stats(void) {
	int t_indx = getix(type);
	if(local_op_mode[DISP_MODE] == STAT_PAGE &&
		(local_op_mode[NEW_PAGE] || stat_change) &&
		t_indx >=0 && Tint[t_indx].row < 20) {
	AcquireMutex(bios_mutex);
	gotoxy(51,Tint[t_indx].row);
	AcquireMutex(rlist_mutex);
	cprintf("%3d",nrec);    // number of records
	if(nrec > 0) {
		for(int i=nrec; i > 0; i--)
			if(list[i-1]->get_flag() != N_FLAG) break;
		cprintf("  %3d  ",(nrec - i));
		list[nrec-1]->get_ts().getts(lod.dispbuf);
		cputs(lod.dispbuf);
		}
	ReleaseMutex(rlist_mutex);
	ReleaseMutex(bios_mutex);
	}
	stat_change = 0;
	if(local_op_mode[NEW_PAGE]) {
		local_op_mode[NEW_PAGE]++;
		if(local_op_mode[NEW_PAGE] > NUM_DISP)
			local_op_mode[NEW_PAGE] = 0;
		}
	}

int rlist::set_last(int n) { // last record to display from n
	if(nrec < 1) return -1;
        int num_lines = 0;
	while(n < nrec) {
		if(list[n]->get_flag() == Z_FLAG) {
                        n++;
			continue;
                        }
		int nl,extra;
        	nl = list[n]->get_nf();
		extra = (list[n]->getn() > 65) ? 1 : 0;
		if(num_lines + nl + extra > 22) break;
		num_lines += nl + extra;
                n++;
		}
	return n - 1;
        }

void rlist::display_page(void) {   // exploits human-readable time-code
	AcquireMutex(bios_mutex);
	clrscr();
	ReleaseMutex(bios_mutex);
	int r_indx = getix(type);
	if(r_indx < 0) {
		AcquireMutex(bios_mutex);
		gotoxy(1,25);
		cputs(Tint[r_indx].a);
		cputs(":Invalid list");
		ReleaseMutex(bios_mutex);
		return;
		}
	if(nrec < 1) {
		AcquireMutex(bios_mutex);
		gotoxy(1,25);
		cputs(Tint[r_indx].a);
		cputs(":Empty list");
		ReleaseMutex(bios_mutex);
		return;
		}
	AcquireMutex(rlist_mutex);
	int rec_indx = next;
	while(rec_indx <= last && last < nrec) {
		if(list[rec_indx]->get_flag() == Z_FLAG) {
                        rec_indx++;
			continue;
                        }
	        int line_len;
		line_len = list[rec_indx]->get_str(MAX_CHAR,lod.dispbuf);
		if(line_len < 15) continue;
                lod.dispbuf[line_len - 1 - 2*strlen(NL)] = '\0'; // eliminate the $ line
                int j = 0;
                if(line_len > 76 && lod.dispbuf[23] == STX) {
			lod.dispbuf[23] = '\0';
			AcquireMutex(bios_mutex);
                	cputs(lod.dispbuf);
                        cputs(NL);
			ReleaseMutex(bios_mutex);
                        j = 24;
			}
		AcquireMutex(bios_mutex);
               	cputs(lod.dispbuf + j);
                cputs(NL);
		ReleaseMutex(bios_mutex);
                rec_indx++;
		}
	ReleaseMutex(rlist_mutex);
	}

void rlist::set_next(int way) {
	int nr,lr = 0;
	if(nrec < 1) return;
	switch(way) {
		case PG_DN: next = last + 1;
		case HOME:  next = 0; break;
		case END:   next = nrec - 1; break;
		case PG_UP: nr = next;
        		while(nr > 0 && (lr = set_last(nr)) >= next) nr--;
                	next = nr; break;
		case UP_AROW: if(next > 0) next--; break;
		case DN_AROW: if(next < nrec - 1) next ++; break;
		}
        if(lr) last = lr;
	else {
		last = set_last(next);
                if(last >= nrec - 1) {
	                nr = next;
                	while(nr > 0 && (lr = set_last(nr)) >= nrec - 1) nr--;
                        last = nrec - 1;
                        if(next < last) next = nr + 1;
                        }
                }
	}

void queue::queue(int m) {
	entries = new int[m];
	if(entries) max_entries = m;
	else max_entries = 0;
	indx = -1;
	}

void queue::~queue(void) {
	delete []entries;
	}

int queue::push(int e) {
	if(indx < max_entries - 1) {
		++indx;
		entries[indx] = e;
		}
	return indx; // points to top entry, or -1
	}

int queue::pop(void) {
	int ret = -10000;
	if(indx >= 0) {
		ret = entries[0]; // FIFO queue
	   	for(int pos = 0; pos < indx; pos++) // move down
			entries[pos] = entries[pos + 1];
	   	indx--; // one entry extracted
		}
	return ret;
	}

static char qname[PATH_LENGTH];

#ifdef SIMULATION
int queue::load(const char *name) {
	int qlen = strlen(path);
	strcpy(qname,path);
	qname[qlen] = 92; // '\'
	strcpy(qname + qlen + 1,name);
	AcquireMutex(bios_mutex);
	fstream instream(qname);
	if(! instream) {
		endprog = 1;
		log(program,"Cannot open queue",instream.rdstate(),3);
		}
	else {
		indx = -1;
		int qval;
		while(!.eof()) {
			qval = -1;
			 >> qval;
			if(qval >= 0 && qval < 1000 && indx < max_entries - 1) {
				entries[++indx] = qval;  // get the data
				}
			instream.getline(msc.diskbuf, MAX_CHAR); // ignore rest of line
			}
		instream.close();
        	nstream.clear();
		log(ccf, qname, indx+1, 5);
		}
	leep(3);
	ReleaseMutex(bios_mutex);
	return (indx);
	}
#endif
