// msc.cpp 1.22 MSC main program
// 1.03: tuning of ComThread
// 1.04: addition of ComTimer/Event to stop printing abends
// 1.22: changed exit delay and speed_cnt

#define SCOPE
#define MAIN
#include "globals.h"
#include <process.h>

int *BITE_STK;  // Checklists stack
int *COM1_STK;  // ComThread stack
int *COM2_STK;  // ComThread stack
int *COM3_STK;  // ComThread stack
static HANDLE CheckerTimer; // Embedded DOS Timer handle for archiving
static HANDLE ChkWatchDogTimer;  // looks for process fail
static HANDLE MainTimer;         // slows down main
void exit_handler(void);
void MainResponder(void);

void disp_use(void) {
    for(int i = 0; i < NUM_USE; i++) cerr << i << ':' << InUse[i] << ' ';
	cerr << endl;
	}

THREAD Com1Thread(void) {
	while(endprog == 0) {
		InUse[6] = 1;
		speed_cnt += p_line.Protocol(); // handles all X.25 communications
		PassTimeSlice();
		marker(3);
#ifdef TRACE
		trp.displayled(1);
		trp.display_data();
#endif
		}
	InUse[6] = 0;
	DeallocateThread();
	}

THREAD Com2Thread(void) {
	while(endprog == 0) {
		InUse[8] = 1;
		speed_cnt += com2.Protocol(); // handles all MBC communications
		PassTimeSlice();
		marker(4);
#ifdef TRACE
		trp.displayled(1);
		trp.display_data();
#endif
		}
	InUse[8] = 0;
	DeallocateThread();
	}

THREAD Com3Thread(void) {
	while(endprog == 0) {
		InUse[9] = 1;
		speed_cnt += b_line.Protocol(); // handles all Backup communications
                PassTimeSlice();
		marker(5);
#ifdef TRACE
                trp.displayled(1);
                trp.display_data();
#endif
		}
	InUse[9] = 0;
	DeallocateThread();
	}

THREAD CheckLists(void) {
	int r_id=0;
	while(endprog == 0) {
#ifdef SIMULATION
		if(list_flag) sim.Addcmd(); // adds a simulated mbc or msc command to ccf_in
#endif
		r_id++;
		InUse[1] = r_id + 1;
		int ret=exch.ccf_out.del_rec();
		if(ret < 1) ret=exch.mbc_out.del_rec();
		if(ret < 1) ret=exch.ccf_in.del_rec();
		if(ret < 1) ret=exch.mbc_in.del_rec();
		if(ret < 1) ret=exch.env_in.del_rec();
		if(ret < 1) ret=exch.fac_out.del_rec();
		if(ret < 1) ret=lod.email.del_rec();
		if(ret < 1) ret=lod.msgs.del_rec();
		if(ret < 1) ret=loglist.del_rec();
            	if(ret < 1) {  // no delete ocurred
			switch(r_id) {
           			case 0: case 1: case 2: case 3:
					if(wth.getpstatus(H_MASK | PORT_SET) ==
				    (H_MASK | PORT_SET) && InUse[5] == 0)
				    		q_wthr.push(1009 + r_id);break;
                                case 4: if(wth.getpstatus(H_MASK | PORT_SET) ==
				    (H_MASK | PORT_SET) && InUse[5] == 0)        	q_wthr.push(1005); // start the weatherlink
				        q_wthr.push(1021); // send one sample of all data
                                        break;
                                case 5: if(wth.getpstatus(H_MASK | PORT_SET) ==
				    (H_MASK | PORT_SET) && InUse[5] == 0)
                                        q_wthr.push(1005); // start the weatherlink
                                        break;
				case 6: c_flag = 1;break;
            			case 7: env_flag = 1;break;
 				default: r_id = -1; b_flag = 10;
				}
                        }
#ifdef KEEP_ALIVE
		pio.Reboot(invunit);  // do a keep_alive
#endif
		msc.test(); // update free memory and disk free values
		if(local_op_mode[DISP_MODE] == STAT_PAGE && ret == 0) {
			AcquireMutex(bios_mutex);
			gotoxy(1,22);
			ts tmp_ts;  // for time
			tmp_ts.getts(lod.dispbuf);
			cputs(lod.dispbuf);
			gotoxy(34,22);
			cprintf("%5u",PgmPeriod.v);
			gotoxy(50,22);
			cprintf("%5u",CheckTime.v);
			ReleaseMutex(bios_mutex);
			}
                marker(2);
#ifdef TRACE
                trp.displayled(0);
		trp.displaydigit(1+(ret != 0));
#endif
		StartTimer(ChkWatchDogTimer, 60000); // 1.04, was 20001.04, moved
		WaitEvent(CheckerEvent);
		}
	StopTimer(CheckerTimer);
	StopTimer(ChkWatchDogTimer);
	InUse[1] = 0;
	DeallocateThread();
	}

void far CheckerResponder(void) {
	StartTimer(CheckerTimer, CheckTime.v);
    	PulseEvent(CheckerEvent);
	}

void far ChkWatchDogResponder(void) {
	cerr << "Checker WatchDog:";
	disp_use();
	cerr << endl;
	AbortThread(CheckerHandle);
	InUse[1] = 0;
	endprog = 9;
        // COLDBOOT
/*	asm {
                MOV	AX,0040;
                MOV	DS,AX;
                MOV	AX,7F7F;
                MOV	[0072],AX;
                JMP	FFFF:0000;  // won't assemble, abs location
        	} */
//      execlp("COLDBOOT",NULL);   // causes a debug trap
	}


void exit_handler(void) {
	msc.store_date();
        }

void MainResponder(void) {
        StartTimer(MainTimer, MainPeriod.v);
        PulseEvent(MainEvent);
	}

int main(int argc, char **argv) {
#ifdef TRACE
	trp.displaydigit(98);
#endif
        atexit(exit_handler); // records program termination
	int ret;
	local_op_mode[DISP_MODE] = LOG_PAGE;
	int i;
	BITE_STK = new int[S_LEN]; // stacks for main program THREADs
	COM1_STK = new int[S_LEN];
	COM2_STK = new int[S_LEN];
	COM3_STK = new int[S_LEN];
	if(BITE_STK == NULL || COM1_STK == NULL ||
	 COM2_STK == NULL || COM3_STK == NULL) exit(4);
#ifdef SIMULATION
	list_flag = 1;  // auto test mode
#endif
#ifdef TEST_MODE
	for(i=0;i<S_LEN;i++) {
		BITE_STK[i] = STKMARK;
		COM1_STK[i] = STKMARK;
		COM2_STK[i] = STKMARK;
		COM3_STK[i] = STKMARK;
		}
#endif
	for(ret=0; ret<argc; ret++)
		cout << " Arg " << ret << " = " << argv[ret];
	cout << ",MSC program version = " << msc_version << endl;
	log(program,msc_version,(int)debug_level.v,5);
	if(argc > 1) {
		ret = atoi(argv[1]);
		if(ret > 0 && ret < 64) {
			debug_level.v = ret;
			}
		}
	if(argc > 2) {
		ret = atoi(argv[2]);
		if(ret > 99 && ret < 27500) CheckTime.v = ret; //1.02 was 32100
		}
	msc.test(); // sets dtable and old_core
	msc.store_date(); // records program start in /msc/data/CRASHREC.RST
#ifdef SIMULATION
	list_flag = 0;
	if(com2.get_active())log(program,"Command Period:",CheckTime.v,5);
#endif
	if(AllocateTimer(&CheckerTimer, 0, CheckerResponder) == 0) {
		cout << "No Archiving Timer" << endl;
		exit(1);
		}
	PgmHandle = AllocateThreadLong(pgm_cntl,FP_SEG(P_STK),NPRI);
	AllocateEvent(&CheckerEvent);
	CheckerHandle=AllocateThreadLong(CheckLists,FP_SEG(BITE_STK),H1PRI);
	Com1Handle=AllocateThreadLong(Com1Thread,FP_SEG(COM1_STK),L1PRI);
	Com2Handle=AllocateThreadLong(Com2Thread,FP_SEG(COM2_STK),L1PRI);
	Com3Handle=AllocateThreadLong(Com3Thread,FP_SEG(COM3_STK),L1PRI);
	AllocateTimer(&ChkWatchDogTimer,0,ChkWatchDogResponder); // may restart program
	AllocateTimer(&MainTimer,0,MainResponder);
	int keyp;
	StartTimer(CheckerTimer, CheckTime.v); // first start, does archiving
	StartTimer(PgmTimer, PgmPeriod.v);
	StartTimer(MainTimer, MainPeriod.v);
	log(program,"Timezone (Zone/Daylight)",((int)(timezone/225)+daylight),5);
/*	cout << "Size of Parse is " << sizeof(exch) << endl;   // 11776
	cout << "Size of Rlist is " << sizeof(loglist) << endl; // 1958
	cout << "Size of Queue is " << sizeof(q_cntl) << endl;  // 8
	cout << "Size of Recordis " << sizeof(loglist[0]) << endl; // 16
	cout << "Size of ccf_port is " << sizeof(p_line) << endl;    // 73
	cin >> i; */
	msgtype ret_type;
	do {
		exch.get_ccf(); // separates ccf messages by type
		InUse[0] = 1;
		PassTimeSlice();
		ret_type=exch.put_ccf();  // adds messages for the CCF
		InUse[0] = 2;
		AcquireMutex(bios_mutex);
                ret = bioskey(1);
		ReleaseMutex(bios_mutex);
		if(ret) {
			AcquireMutex(bios_mutex);
			keyp = bioskey(0);
			ReleaseMutex(bios_mutex);
			if((keyp & 0xff) == 0) {
				InUse[0] = 3;
				lod.new_display(keyp >> 8); // F1 .. F10
				}
			else {
				keyp &= 0x7f;
				if(keyp == 16) { // control-p
					q_cntl.push(7); // turn on facility power
					}
				else {
					InUse[0] = 4;
					lod.update_cmd(keyp);
					}
				}
			}
		if(ret_type == invtype) WaitEvent(MainEvent);
		else PassTimeSlice();
		marker(0);
#ifdef TRACE
                trp.displayled(2);
#endif
		}
	while(!endprog);
	lod.new_display(LOG_PAGE); // return to log display,1.02 was 60
	InUse[0] = 0; // 1.04
//	EnterCriticalSection();
//	comsetMCR(COMIRQ,0x0c);  // disable DTR & RTS & interrupts;1.02 deleted
//	LeaveCriticalSection();
	SetEvent(CheckerEvent);
	SetEvent(PgmEvent);
	int j,k=2*(CheckTime.v/MainPeriod.v);
	for(i = 1; i < NUM_USE; i++) {
		j = 0;
		if(InUse[i]) {
			cerr << "\rWaiting for Thread # " << i << " to finish...";
			while(++j < k && InUse[i])
			WaitEvent(MainEvent);
			cerr << "\b\b\b:delay = " << j << endl;
        	}
        if(j >= k) {
        	switch(j) {
            		case 6: AbortThread(Com1Handle);break;
            		case 8: AbortThread(Com2Handle);break;
            		case 9: AbortThread(Com3Handle);break;
			case 3: AbortThread(cntl_handle);
         		}
            }
		}
//	local_op_mode[DISP_MODE] = LOG_PAGE;  1.02 deleted
	DeallocateTimer(CheckerTimer);
	DeallocateEvent(CheckerEvent);
	DeallocateTimer(ChkWatchDogTimer);
	DeallocateEvent(MainEvent);
	DeallocateTimer(MainTimer);
#ifdef TRACE
	trp.displaydigit(99);
#endif
#ifdef TEST_MODE
	j = 0;
	for(i=0;i<S_LEN;i++) if(BITE_STK[i] != STKMARK) j++;
	log(program,"Check Stack used=",j,8);
	j = 0;
	for(i=0;i<S_LEN;i++) if(COM1_STK[i] != STKMARK) j++;
	log(program,"Com 1 Stack used=",j,8);
	j = 0;
	for(i=0;i<S_LEN;i++) if(COM2_STK[i] != STKMARK) j++;
	log(program,"Com 2 Stack used=",j,8);
	j = 0;
	for(i=0;i<S_LEN;i++) if(COM3_STK[i] != STKMARK) j++;
	log(program,"Com 3 Stack used=",j,8);
#endif
	delete []BITE_STK;
	delete []COM1_STK;
	delete []COM3_STK;
	delete []COM2_STK;
	sleep(2);  // had problems with the early log messages from desc.
	return endprog;
	}
