rem Spa Temp Display.bas.  Spa Temperature Display  from the Spa thermostat
rem The thermostat program is thermostat4800.bas
rem When the spa is off, the ambient temperature from a LM335 is displayed
rem serin is too slow for 9600 baud, or separate variables at 4800 baud
rem John Saunders 11/4/2012	Added leading 0 blanking

#picaxe 14M2

'Input ports
symbol SerData       = C.2	'Serial Data from the Spaq Thermostat
symbol TempSensor    = C.4	'LM335 voltage

'Output ports
symbol DisplayLatch  = B.3	'Latches the 74HC595 shift register parallel outputs.
symbol DisplayClock  = B.2	'Shifts the displat data into the 74HC595s
symbol DisplayPort   = B.1	'Data into the 74HC595s
symbol BeepPort      = B.4
symbol LEDPort       = B.5

'Variables 
symbol DisplayData   = B0	'Hex Data to go to the 74HC595
symbol Mask          = B1
symbol MaskAddr      = B2
symbol Scratch       = B3
symbol Temp          = B4
symbol AnalogCount   = B5
symbol Flowing       = B10
symbol AnalogValue   = W11	'Voltage from the LM335
symbol AnalogReading = W12

'EEPROM
DATA 0,(8,4,2,1)		       'For the 74HC595, MSB first


Init:
LOW DisplayLatch		'Clocks on rise
LOW DisplayClock		'Clocks on rise
LOW BeepPort		'Not presentlt used
LOW LEDPort			'Not presentlt used
AnalogValue = 0
AnalogCount = 0

Main:
LET bptr = 28	'Outputs "Z" followed by 4-digit 3.1 temp,a comma, Gas flowing  (1,0), CRLF
SERIN [1000,TempAlt],SerData,N4800_4,("Z"),@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptr
LOW DisplayClock
LOW DisplayLatch
HIGH DisplayPort 
FOR scratch = 0 TO 3 	'Least significant digit first
	LOOKUP Scratch,(32,30,29,28),bptr
	LET DisplayData = @bptr - 48
	GOSUB SendHex
NEXT
PULSOUT DisplayLatch,10
PAUSE 500	'The thermostat cycles at 880 ms due to the temperature sensor slowness
GOTO Main
TempAlt:
READADC10 TempSensor,AnalogReading	'At Vcc=5.12 each count is 5mv and 0.5 deg C
AnalogValue = AnalogValue + AnalogReading
AnalogCount = AnalogCount + 1
IF AnalogCount >= 9 THEN
	AnalogValue = AnalogValue - 4597	'18*273.15 - 320 to get deg F
	GOSUB DisplayNumber
	AnalogValue = 0
	AnalogCount = 0
ENDIF
GOTO Main

SendHex:			'Most significant bit first
FOR MaskAddr = 0 TO 3
	IF Scratch = 3 AND DisplayData = 0 THEN
		LET DisplayData = 15
	ENDIF
	READ MaskAddr,Mask
	LET Temp = DisplayData & Mask
	LOW DisplayPort
	IF Temp = 0 THEN HexBitisLow
	HIGH DisplayPort	
HexBitisLow:
	PULSOUT DisplayClock,10
NEXT
RETURN

DisplayNumber:			'Least significant digit first		
LOW DisplayLatch		'Clocks on rise
LOW DisplayClock		'Clocks on rise
HIGH DisplayPort 
FOR Scratch = 0 TO 3
	LET DisplayData = AnalogValue //10
	GOSUB SendHex 
	LET AnalogValue = AnalogValue / 10
NEXT
PULSOUT DisplayLatch,10
RETURN