#rem 14M2.bas is the program for the auxiliary procrssor on the main moard of the Standalone DAU
It has 3 functions:
1. A rgb LED shows the battery voltage in bands.
2. It sends a LOW to the shutoff input if the battery voltage is below the safe discharge for a LiIon battery.
3. It turns the charger on for a low battery voltage and off when charged
It is powered from switched battery voltage., draw is 1.6 MA
John Saunders 10/8/2021
#endrem
#picaxe14M2

rem Input
symbol refPort = B.1			'1.235V

rem outputs
symbol chgCtlPort = B.4			'LOW is charge on
symbol shutPort	= B.5			'LOW is shutoff
symbol greenLED	= C.0
symbol blueLED	= C.1
symbol redLED	= C.2

rem constants
symbol shutCount		= 389		'3,3V, measured 3.30
symbol chargeOn		= 378		'3,4V,  measured 3.36
symbol blueRedCount	= 367		'3,5V, measured 3.43
symbol restoreCount	= 357		'3,6V, measured 3.61
symbol greenBlueCount	= 338		'3,8V, measured 3.75
symbol chargeOffCount	= 313		'4.1V, measured 4.12
symbol initDelay		= 5000
symbol blinkMax		= 5
symbol blinkDelay		= 100

rem variables
symbol charging	= bit0		'1 is charge enabled
symbol running	= bit1		'1 is 5V power enabled
symbol blinkCount	= b1			'To contro red LED blinking
symbol refCount	= w6


Init:
rem Set initial default state and wait to see if there will be a change
LET charging = 1		'Default is charging enabled
LOW chgCtlPort
LET running = 1		'Default if power on
HIGH shutPort
GOSUB LedControl
PAUSE initDelay

Main:
INC blinkCount
IF blinkCount > blinkMax THEN
	LET blinkCount = 0
ENDIF
GOSUB LedControl
rem See if battery should shutoff 5V
IF refCount > shutCount AND running = 1 THEN
	LET running = 0
ENDIF
rem See if battery voltage has become high enounh to restore 5V
IF refCount < restoreCount AND running = 0 THEN
	LET running = 1
ENDIF
IF running = 1 THEN 
	HIGH shutPort
ELSE
	LOW shutPort
ENDIF
rem See if charging should commence
IF refCount > chargeOn AND charging = 0 THEN
	LET charging = 1
ENDIF
rem See if battery voltage has become high enounh to turn off charging
IF refCount < chargeOffCount AND charging = 1 THEN
	LET charging = 0
ENDIF
IF charging = 1 THEN 
	LOW chgCtlPort
ELSE
	HIGH chgCtlPort
ENDIF	
PAUSE blinkDelay
GOTO Main

LedControl:
READADC10 refPort,refCount
IF refCount < greenBlueCount THEN
	LOW greenLED	
	HIGH blueLED
	HIGH redLED
ELSEIF refCount < blueRedCount THEN
	LOW blueLED
	HIGH greenLED
	HIGH redLED
ELSE
	IF blinkCount = 1 THEN
		LOW redLED
	ELSE
		HIGH redLED
	ENDIF
	HIGH greenLED
	HIGH blueLED
ENDIF	
RETURN