rem Stepping_Clock.bas John Saunders 9/5/2009

#picaxe 18X

rem constants
rem These activate only one of the eight windings at a time
symbol my = %00010000	'minute stepper yellow wire
symbol mr = %00100000	'minute stepper red wire
symbol mo = %01000000	'minute stepper orange wire
symbol mb = %10000000	'minute stepper brown wire
symbol hy = %00000001	'hour stepper yellow wire
symbol ho = %00000010	'hour stepper orange wire
symbol hk = %00000100	'hour stepper black wire
symbol hn = %00001000	'hour stepper brown wire
symbol lowlimit = 80	'Motor supply volts in tenths
symbol correctionLimit = 13330 'This watch is fast by 75 ppm

rem variables
symbol restoretime = bit0
symbol mp = b1		'Minute Stepper phase
symbol hp = b2		'Hour Stepper phase
symbol cal = b3		'ADC output for a regulated 3.17 V input
symbol ms = b4		'ADC Motor supply output times 0.16 divider 
symbol seconds = b5
symbol ticks = b6		'Times the minute hand moves
symbol pcode = b7
symbol poweroutcount = w4 'No of seconds power was lost
symbol correctionCount = w5 'To correct for watch Xtal error

init:
LET mp = 0
LET hp = 0
LET seconds = 0
LET ticks = 0
LET poweroutcount = 0
LET restoretime = 0
LET correctionCount = 10000

main:
rem Correct for watch error
LET correctionCount = correctionCount + 1
IF correctionCount > correctionLimit THEN
	LET correctionCount = 0
	GOTO skipAsec
ENDIF

IF seconds > 17 THEN		'One hour = 3600secs/200steps = 18 secs per step
	GOSUB stepminute
	LET seconds = 0
ELSEIF restoretime = 1 THEN	'Step forward and decrement lost second count
	LET poweroutcount = poweroutcount - 18
	LET restoretime = 0
	GOSUB stepminute
ENDIF

LET seconds = seconds + 1

IF ticks > 11 THEN	'The hour hand steps once for 12 minute steps
	GOSUB stephour
ENDIF

rem Check the motor supply voltage
READADC 1,ms	' 12 V * 0.16
READADC 0,cal	' 3.17 volts regulated
LET ms = 198*ms/cal  'To correct for the changing ADC reference
'LET cal = 8120/cal
'SERTXD ("Battery volts = ",#cal,", Motor volts = ",#ms,13,10)
IF ms > lowlimit THEN
	IF poweroutcount > 17 THEN
		LET restoretime = 1
	ENDIF
ELSE
	LET poweroutcount = poweroutcount + 1	'Save the missing seconds
	LET restoretime = 0
ENDIF
skipAsec:
DO			'A 1-second period, 2.5ms width negative-going pulse
	PAUSE 1
LOOP WHILE INPUT6 = 1
goto main
end

stepminute:
rem mimute motor is MSJE200, 200 steps per rev.
rem unipolar 4-phase
rem port order:yellow=4,red=5,orange=6,brown=7
rem cw :step order is brown red orange yellow
LOOKUP mp,(mb,mr,mo,my),pcode
LET PINS = pcode
PAUSE 20
LET PINS = 0
LET mp = mp + 1
IF mp > 3 THEN
	LET mp = 0
ENDIF
LET ticks = ticks + 1	'Count for the hour hand
return

stephour:
rem hour is a Copal 200 steps per rev
rem unipolar 4-phase
rem port order yellow=0,orange = 1,black=2,brown=3
rem ccw: step order is brown orange black yellow
rem bevel gears reverse direction
LOOKUP hp,(hn,ho,hk,hy),pcode 
LET PINS = pcode
PAUSE 20
LET PINS = 0
LET hp = hp + 1
IF hp > 3 THEN
	LET hp = 0
ENDIF
LET ticks = 0		'Reset hour hand count
return



