rem Transistor Tester.bas.  This device quickly determines whether a transistor is NPN or PNP,
rem whether it is pinned E-B-C or E-C-B and whether it was made with silicon or germanium.
rem It does this by measuring the Collector to Base voltage and then the Emitter to Base voltage
rem for a 3.3 MA current. When connected properly, both are in the correct range for their
rem chemistry.The different connections are performed by three multi-contact form C telephone
rem type relays. It tries the most common configurations in turn. It stops when a valid answer
rem is found or if it detects a short. A momentary-contact switch controls 24V relay power
rem and also restarts the program for the next test. Five LEDs show the final configuration
rem and whether a valid result has been obtained. There is an unnecessary serial output.

#picaxe 14M

rem Pins
symbol RelayA = 2		'Controls PNP - NPN awitching and Red LED. Lights for a PNP.
symbol RelayB = 1		'Controls Emitter - Collector measurement awitching.
symbol RelayC = 3		'Controls e-b-c and e-c-b awitching and Yellow LED, lights for
				'a reversal of collector and base pins.	
symbol GerLED = 4		'Large Green LED lights for germanium, flashes for a short.
symbol FinLED = 5		'Small green LED is steady for a valid result, or
				'flashes of no result has been obtained after all 4 tries
symbol VoltPin = 0	'Base-Collector ot Base Emitter voltage drop
symbol Enable = Pin1	'Momentary switch starts the test and restarts between tests
				'It also controls the 14-volt relay power.

rem variabled=s

symbol VCB = w4
symbol VEB = w5

rem constants

symbol Cal   = 5		'Count of 1000 is assumed to be 5 volts. Result is millivolts
symbol UpSi  = 950	'The voltage drop of a silicon transitor should be less than this
symbol LowSi = 500	'The voltage drop of a silicon transitor should be more than this
symbol Short = 90		'The voltage drop of a germanium transitor should be more than this

init:
LOW FinLED
LOW GerLED
PAUSE 100
IF Enable = 0 THEN init	'Wait until switch pressed
PAUSE 200 			'Debounce


main:
rem This first try is for a correctly connected NPN transistor
LOW RelayA
LOW RelayC 
SERTXD ("NPN,DIR")
GOSUB MakeMeasurement
rem The next try is for a incorrectly connected NPN transistor
LOW RelayA
HIGH RelayC 
SERTXD ("NPN,REV")
GOSUB MakeMeasurement
rem Now try for a correctly connected PNP transistor
HIGH RelayA
LOW RelayC 
SERTXD ("PNP,DIR")
GOSUB MakeMeasurement
rem The last try is for a incorrectly connected PNP transistor
HIGH RelayA
HIGH RelayC 
SERTXD ("PNP,REV")
GOSUB MakeMeasurement
rem If this point is reached then there is a MOSFET or a bad connection

failLoop:		'Flash the small green LED for an open or MOSFET
LOW GerLED
HIGH FinLED
IF Enable = 0 THEN init
PAUSE 90
LOW FinLED
PAUSE 90
GOTO FailLoop

ShortLoop:		'Flash the large green (Germanium) LED for a short
LOW GerLED
IF Enable = 0 THEN init
PAUSE 90
HIGH GerLED
PAUSE 90
GOTO ShortLoop
END



MakeMeasurement:
LOW RelayB
PAUSE 150						'Wait for relay, takes 110 ms to release
READADC10 VoltPin,VCB
LET VCB = VCB * Cal
HIGH RelayB
PAUSE 50						'Wait for relay, takes 15 ms to close
READADC10 VoltPin,VEB
LET VEB = VEB * Cal
SERTXD (",VCB = ",#VCB,",VEB = ",#VEB,13,10)	'Optional
IF VCB > UpSi OR VEB > UpSi THEN RETURN	'Not forward biassed
ENDIF
IF VCB < Short OR VEB < Short THEN ShortLoop	'Shorted
HIGH FinLED						'Valid result, light small green LED steady.
IF VCB < LowSi AND VEB < LowSi THEN		'Must be germanium
	HIGH GerLED
ENDIF
DO							'Wait to release the switch
	PAUSE	100
	IF Enable = 0 THEN EXIT
LOOP
GOTO Init



