#rem
rgbMatrixReceiver.bas 
This is for the picaxe receiver, pert of the matrix display
John Saunders  4/25/2020 New Garage Fan message. 
5/7/2020 Restrict to OA-OF, added notification count
5/20/2020 Added r message and fields
#endrem
#picaxe 14M2

'Ports
symbol	Integrator  = PinC.0
symbol	Ready	= pinC.2	'A 1 triggers a transmission to the Arduino
symbol	Rcvr_Port   = B.5		'Idle low
symbol	Photocell   = B.2	      'Darker is greater

rem Interrupt only symbols
symbol	RcvrIn      = b1 
symbol	MsgLen      = b2
symbol	RcvrCnt     = b3
symbol	ChckSum     = b4
symbol	Pulse_Cnt   = b5
symbol	I_tmp       = b6
symbol	ChckHex	= b7
symbol	RcvrHex	= b8
symbol	In_data	= b9

rem Global Symbols
symbol	NewData	= bit1
symbol	SolarAge    = b11
symbol      TimeAge     = b12
symbol      LoopCount   = b13
symbol     darkOverride = b14
symbol	NotCount	= b15

rem general variables
symbol	Iter       = b16
symbol	Raw       = b17

rem constants
symbol	Per       = 200
symbol       Twosec  = 20
symbol	I2Clen  = 30
symbol 	Darkness = 205
symbol	 maxOverride = 60
symbol	NotCountMax = 5	

#rem Memory allocation
Address       Key        Bytes              Type                 Content
28                O            1                   Uint8_t             Command in 3 bits + 5 individual bits
29                other      1                   Char                 Event message key
30-37           t             8                   Char	         Month,Date,Hour,Minute(2 ea)		
38-49           s           12                   Char	         Ext Temp,Ext Hum,Solar Curr, Batt Volts(3 ea)
50- 52          u            3                   Char	         G-temp(3)
53-55           r           12                   Char	         Pressure
56-58           r           12                   Char	       Charge Volt
bits 3-7 of b0
b0		u            1                   Char		G-Door(1) 'U' or 'D', bit 3
b0		u            1                   Char		G Temperature(1) 'H' or 'C', bit 4
b0		u            1                   Char		G-fan(1) 'R' or 'S', bit 5
b0              NA           1                   Uint_8             Time ageing > 60, bit 6
b0               NA           1                   Uint_8             Solar ageing > 60, bit 7

#endrem

Init:
SETFREQ m8
LET NewData = 0
LET NotCount = 0
HI2Csetup I2CMASTER,0x0E,I2Cslow_8,I2Cbyte
SETINT %00000001,%00000001	'Interrupt when C.0 high

Main:
PAUSE Per
INC LoopCount
IF darkOverride > 0 THEN
	DEC darkOverride
ENDIF
IF LoopCount >= TwoSec THEN
	LET LoopCount = 0;
	IF SolarAge < 255 THEN
		INC SolarAge
		IF  SolarAge > 60 THEN
			bit7 = 1
		ELSE
			bit7 = 0
		ENDIF
	ENDIF
	IF TimeAge < 255 THEN
		INC TimeAge
		IF  TimeAge > 60 THEN
			bit6 = 1
		ELSE
			bit6 = 0
		ENDIF
	ENDIF
	READADC Photocell,Raw
	IF Raw > Darkness  AND darkOverride = 0 THEN
		POKE 28,"F"
	ENDIF
ENDIF
IF Ready = 1  THEN		'Tailored to 32 bytes-max for the Mega I2C
	SETINT OFF
	LET bptr = 28
	HI2COUT (@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,    @bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,   @bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc ,@bptr,b0)	
	SETINT  %00000001,%00000001	'Interrupt when C.0 high
ENDIF
GOTO Main

Interrupt:
LET bptr = 128		'Max is 511
LET RcvrIn = "Z"
LET Pulse_Cnt = 0
DO WHILE Integrator = 1
	LET  Pulse_Cnt = Pulse_Cnt + 1
LOOP				'There is a 10 ms gap before the code to allow the serin to execute
IF Pulse_Cnt < 5 OR Pulse_Cnt > 121 THEN NotMine '10 for t & s, 15 for p or r                                           
rem                                                            Msg_Key     ,          MsgLen        ,	     byte1...
SERIN [80],Rcvr_Port,N2400_8,("14L1776"),RcvrIn,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc, @bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,  @bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc, @bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc
IF RcvrIn = "Z" THEN NotMine
IF RcvrIn =  "O" THEN
	PEEK 129,i_tmp  'Display Command "A" - "F"
	IF i_tmp >= "A" AND i_tmp <= "F" THEN
		POKE 28,I_tmp
	ENDIF
	LET darkOverride = maxOverride
ELSEIF Rcvrin >= " " AND RcvrIn <   "n" THEN
	POKE 29,Rcvrin						'Event for notification
	LET NotCount = 0
ELSE									'Check checksum				
	PEEK 129, MsgLen
	IF MsgLen < 61 OR MsgLen > 110 THEN NotMine
	LET RcvrCnt = MsgLen + 70		'Address of last message byte
	LET ChckSum = 0
	FOR Bptr =131 TO RcvrCnt
		LET   ChckSum = ChckSum + @bptr
	NEXT
	LET ChckHex = ChckSum / 16
	IF ChckHex < 10 THEN
		LET ChckHex = ChckHex+ "0"
	ELSE
		LET ChckHex = ChckHex + "7"
	ENDIF
	LET bptr = RcvrCnt + 2
	LET RcvrHex = @bptrinc
	IF ChckHex <> RcvrHex THEN NotMine
	LET ChckHex = ChckSum & $F
	IF ChckHex < 10 THEN
		LET ChckHex = ChckHex + "0"
	ELSE
		LET ChckHex = ChckHex + "7"
	ENDIF
	LET RcvrHex = @bptrinc
	IF ChckHex <> RcvrHex THEN NotMine
	SELECT RcvrIn
		CASE  "t"	
			LET bptr = 30
			FOR i_tmp = 131 TO RcvrCnt
				PEEK i_tmp,ChckSum
				IF ChckSum >= "0" AND ChckSum <= "9" THEN
					LET @bptrinc = ChckSum
				ENDIF
			NEXT	
			LET Timeage = 0
			INC NotCount
			IF NotCount > NotCountMax THEN
				POKE 29,"z"					'Cancels notification
			ENDIF
		CASE  "s"
			LET bptr = 38
			FOR i_tmp = 131 TO RcvrCnt
				PEEK i_tmp,ChckSum
				IF ChckSum >= "0" AND ChckSum <= "9" THEN
					LET @bptrinc = ChckSum
				ENDIF
			NEXT
			LET Solarage = 0	
		CASE  "r"
			LET bptr = 53
			FOR i_tmp = 131 TO 137
				PEEK i_tmp,ChckSum
				IF ChckSum >= "0" AND ChckSum <= "9" THEN
					LET @bptrinc = ChckSum
				ENDIF
			NEXT
		CASE  "u"
			LET bptr = 50
			FOR i_tmp = 131 TO 133
				PEEK i_tmp,In_data
				IF in_data >= "0" AND in_data <= "9" THEN
					LET @bptrinc = in_data
				ENDIF
			NEXT
			PEEK 135, in_data			'G-Door
			IF in_data = "U" THEN
				bit3 = 1
			ELSE
				bit3 = 0
			ENDIF
			PEEK 137, in_data			'G-Hot
			IF in_data = "H" THEN
				bit4 = 1
			ELSE
				bit4 = 0
			ENDIF
			PEEK 139, in_data			'G-Fan
			IF in_data = "R" THEN
				bit5 = 1
			ELSE
				bit5 = 0
			ENDIF
	ENDSELECT
ENDIF
NotMine:
SETINT  %00000001,%00000001	'Interrupt when C.0 high
RETURN